/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.lang;

import io.github.portlek.configs.ConfigLoader;
import io.github.portlek.configs.LangLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LangValue<T> {
    private static final Logger log = Logger.getLogger(LangValue.class.getName());
    @NotNull
    private final AtomicReference<String> currentLang = new AtomicReference();
    @NotNull
    private final Class<T> type;
    @NotNull
    private final Map<String, T> values;
    @Nullable
    private LangLoader loader;

    @NotNull
    public static <T> Builder<T> builder(@NotNull Class<T> type) {
        return new Builder<T>(type);
    }

    @NotNull
    public static <T> LangValue<T> create(@NotNull Class<T> type, @NotNull String key1, @NotNull T value1) {
        return LangValue.create(type, Map.entry(key1, value1));
    }

    @NotNull
    public static <T> LangValue<T> create(@NotNull Class<T> type, @NotNull String key1, @NotNull T value1, @NotNull String key2, @NotNull T value2) {
        return LangValue.create(type, Map.entry(key1, value1), Map.entry(key2, value2));
    }

    @NotNull
    public static <T> LangValue<T> create(@NotNull Class<T> type, @NotNull String key1, @NotNull T value1, @NotNull String key2, @NotNull T value2, @NotNull String key3, @NotNull T value3) {
        return LangValue.create(type, Map.entry(key1, value1), Map.entry(key2, value2), Map.entry(key3, value3));
    }

    @NotNull
    public static <T> LangValue<T> create(@NotNull Class<T> type, @NotNull String key1, @NotNull T value1, @NotNull String key2, @NotNull T value2, @NotNull String key3, @NotNull T value3, @NotNull String key4, @NotNull T value4) {
        return LangValue.create(type, Map.entry(key1, value1), Map.entry(key2, value2), Map.entry(key3, value3), Map.entry(key4, value4));
    }

    @NotNull
    public static <T> LangValue<T> create(@NotNull Class<T> type, @NotNull String key1, @NotNull T value1, @NotNull String key2, @NotNull T value2, @NotNull String key3, @NotNull T value3, @NotNull String key4, @NotNull T value4, @NotNull String key5, @NotNull T value5) {
        return LangValue.create(type, Map.entry(key1, value1), Map.entry(key2, value2), Map.entry(key3, value3), Map.entry(key4, value4), Map.entry(key5, value5));
    }

    @SafeVarargs
    @NotNull
    public static <T> LangValue<T> create(@NotNull Class<T> type, Map.Entry<String, T> ... values) {
        return LangValue.create(type, Arrays.stream(values).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, HashMap::new)));
    }

    @NotNull
    public static <T> LangValue<T> create(@NotNull Class<T> type, @NotNull Map<String, T> values) {
        return LangValue.builder(type).setDefaults(values).build();
    }

    @NotNull
    public Optional<T> get(@NotNull String lang) {
        return this.lang(lang).get();
    }

    @NotNull
    public Optional<T> get() {
        return Optional.ofNullable(this.currentLang.get()).map(this.values::get);
    }

    @NotNull
    public LangLoader getLoader() {
        return Objects.requireNonNull(this.loader, "Load the fields before use #getLoader() method!");
    }

    @NotNull
    public LangValue<T> lang(@NotNull String lang) {
        if (this.loader == null) {
            return this;
        }
        boolean control = this.loader.getValues().stream().map(ConfigLoader.Builder::getFileName).filter(Objects::nonNull).anyMatch(lang::equalsIgnoreCase);
        if (control) {
            this.currentLang.set(lang);
        } else {
            log.log(Level.SEVERE, lang + " not found!");
        }
        return this;
    }

    public void put(@NotNull String key, @NotNull T value) {
        this.values.put(key, value);
    }

    public void setHolder(@NotNull LangLoader loader) {
        this.loader = loader;
        loader.getDefaultLanguage().ifPresent(this.currentLang::set);
    }

    private LangValue(@NotNull Class<T> type, @NotNull Map<String, T> values) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        this.type = type;
        this.values = values;
    }

    @NotNull
    public AtomicReference<String> getCurrentLang() {
        return this.currentLang;
    }

    @NotNull
    public Class<T> getType() {
        return this.type;
    }

    @NotNull
    public Map<String, T> getValues() {
        return this.values;
    }

    public static final class Builder<T> {
        @NotNull
        private final Class<T> type;
        @NotNull
        private Map<String, T> defaults = new HashMap<String, T>();

        @NotNull
        public Builder<T> addDefault(@NotNull String key, @NotNull T value) {
            this.defaults.put(key, value);
            return this;
        }

        @NotNull
        public LangValue<T> build() {
            return new LangValue<T>(this.type, new HashMap<String, T>(this.defaults));
        }

        @NotNull
        public Builder<T> setDefaults(@NotNull Map<String, T> defaults) {
            this.defaults = Objects.requireNonNull(defaults, "values");
            return this;
        }

        private Builder(@NotNull Class<T> type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        @NotNull
        public Class<T> getType() {
            return this.type;
        }

        @NotNull
        public Map<String, T> getDefaults() {
            return this.defaults;
        }
    }
}

