/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.Loader;
import io.github.portlek.configs.annotation.Ignore;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.util.FileVersions;
import io.github.portlek.reflection.RefField;
import io.github.portlek.reflection.clazz.ClassOf;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FieldLoader {
    @NotNull
    public static List<FieldLoader> createLoaders(@NotNull Loader loader, @NotNull ConfigHolder holder, @NotNull List<Func> functions, @Nullable RefField parentField, @Nullable ConfigurationSection section) {
        return functions.stream().map(function -> (FieldLoader)function.apply(holder, (ConfigurationSection)Objects.requireNonNullElse(section, loader.getFileConfiguration()))).peek(fieldLoader -> {
            if (parentField != null) {
                fieldLoader.setParentField(parentField);
            }
        }).collect(Collectors.toList());
    }

    public static void load(@NotNull Loader loader, @NotNull ConfigHolder holder) {
        FieldLoader.load(loader, holder, loader.getLoaders(), null, null);
    }

    public static void load(@NotNull Loader loader, @NotNull ConfigHolder holder, @NotNull List<Func> loaders) {
        FieldLoader.load(loader, holder, loaders, null, null);
    }

    public static void load(@NotNull Loader loader, @NotNull ConfigHolder holder, @Nullable RefField parentField, @Nullable ConfigurationSection section) {
        FieldLoader.load(loader, holder, loader.getLoaders(), parentField, section);
    }

    public static void load(@NotNull Loader loader, @NotNull ConfigHolder holder, @NotNull List<Func> functions, @Nullable RefField parentField, @Nullable ConfigurationSection section) {
        List<FieldLoader> loaders = FieldLoader.createLoaders(loader, holder, functions, parentField, section);
        Set<Map.Entry<RefField, FieldLoader>> fields = new ClassOf<ConfigHolder>(holder).getDeclaredFields().stream().filter(field -> !field.hasAnnotation(Ignore.class)).flatMap(field -> loaders.stream().filter(fieldLoader -> fieldLoader.canLoad(loader, (RefField)field)).map(fieldLoader -> Map.entry(field, fieldLoader))).collect(Collectors.toSet());
        FileVersions.load(loader, fields);
        holder.onLoad();
    }

    public boolean canLoad(@NotNull Loader var1, @NotNull RefField var2);

    @NotNull
    public ConfigHolder getHolder();

    @Nullable
    public RefField getParentField();

    public void setParentField(@NotNull RefField var1);

    @NotNull
    public ConfigurationSection getSection();

    public void onLoad(@NotNull Loader var1, @NotNull RefField var2);

    @FunctionalInterface
    public static interface Func
    extends BiFunction<ConfigHolder, ConfigurationSection, FieldLoader> {
    }
}

