/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHGistFile;
import org.kohsuke.github.GHGistUpdater;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHGist
extends GHObject {
    final GHUser owner;
    private String forks_url;
    private String commits_url;
    private String id;
    private String git_pull_url;
    private String git_push_url;
    private String html_url;
    @JsonProperty(value="public")
    private boolean _public;
    private String description;
    private int comments;
    private String comments_url;
    private final Map<String, GHGistFile> files;

    @JsonCreator
    private GHGist(@JacksonInject GitHub root, @JsonProperty(value="owner") GHUser owner, @JsonProperty(value="files") Map<String, GHGistFile> files) {
        this.root = root;
        for (Map.Entry<String, GHGistFile> e : files.entrySet()) {
            e.getValue().fileName = e.getKey();
        }
        this.files = Collections.unmodifiableMap(files);
        this.owner = root.getUser(owner);
    }

    @Override
    @Deprecated
    public long getId() {
        return Long.parseLong(this.getGistId());
    }

    public String getGistId() {
        return this.id;
    }

    public GHUser getOwner() throws IOException {
        return this.owner;
    }

    public String getForksUrl() {
        return this.forks_url;
    }

    public String getCommitsUrl() {
        return this.commits_url;
    }

    public String getGitPullUrl() {
        return this.git_pull_url;
    }

    public String getGitPushUrl() {
        return this.git_push_url;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public boolean isPublic() {
        return this._public;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCommentCount() {
        return this.comments;
    }

    public String getCommentsUrl() {
        return this.comments_url;
    }

    public GHGistFile getFile(String name) {
        return this.files.get(name);
    }

    public Map<String, GHGistFile> getFiles() {
        return this.files;
    }

    String getApiTailUrl(String tail) {
        String result = "/gists/" + this.id;
        if (!StringUtils.isBlank(tail)) {
            result = result + StringUtils.prependIfMissing(tail, (CharSequence)"/", new CharSequence[0]);
        }
        return result;
    }

    public void star() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("PUT")).withUrlPath(this.getApiTailUrl("star"), new String[0])).send();
    }

    public void unstar() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("DELETE")).withUrlPath(this.getApiTailUrl("star"), new String[0])).send();
    }

    public boolean isStarred() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("star"), new String[0])).fetchHttpStatusCode() / 100 == 2;
    }

    public GHGist fork() throws IOException {
        return ((Requester)((Requester)this.root.createRequest().method("POST")).withUrlPath(this.getApiTailUrl("forks"), new String[0])).fetch(GHGist.class);
    }

    public PagedIterable<GHGist> listForks() {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("forks"), new String[0])).toIterable(GHGist[].class, null);
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("DELETE")).withUrlPath("/gists/" + this.id, new String[0])).send();
    }

    public GHGistUpdater update() throws IOException {
        return new GHGistUpdater(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GHGist ghGist = (GHGist)o;
        return this.id.equals(ghGist.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

