/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.replaceable;

import io.github.portlek.replaceable.RpBase;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class RpList
extends RpBase<RpList, List<String>> {
    private RpList(@NotNull List<String> value) {
        super(value);
    }

    @NotNull
    public static RpList from(String ... texts) {
        return RpList.from(Arrays.asList(texts));
    }

    @NotNull
    public static RpList from(StringBuilder ... builders) {
        return RpList.from(Arrays.stream(builders).map(StringBuilder::toString).collect(Collectors.toList()));
    }

    @NotNull
    public static RpList from(@NotNull List<String> list) {
        return new RpList(list);
    }

    @Override
    @NotNull
    public Supplier<RpList> newSelf(@NotNull List<String> value) {
        return () -> new RpList(value);
    }

    @Override
    @NotNull
    public List<String> replace(@NotNull List<String> value, @NotNull CharSequence regex, @NotNull CharSequence replace) {
        return value.stream().map((? super T s) -> s.replace(regex, replace)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public RpList self() {
        return this;
    }
}

