/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

public final class NumberConversions {
    public static double toDouble(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return 0.0;
        }
    }

    public static int toInt(Object object) {
        return NumberConversions.toInt(object, 0);
    }

    public static int toInt(Object object, int fallback) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return fallback;
        }
    }

    public static long toLong(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return 0L;
        }
    }

    private NumberConversions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

