/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.configuration;

import io.github.portlek.configs.configuration.Configuration;
import io.github.portlek.configs.configuration.FileConfigurationOptions;
import io.github.portlek.configs.configuration.MemoryConfiguration;
import io.github.portlek.configs.exceptions.InvalidConfigurationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class FileConfiguration
extends MemoryConfiguration {
    public FileConfiguration() {
    }

    public FileConfiguration(Configuration defaults) {
        super(defaults);
    }

    public void load(@NotNull String file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        this.load(new File(file));
    }

    public void load(@NotNull File file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        this.load(new FileInputStream(file));
    }

    public void load(@NotNull InputStream stream) throws IOException, InvalidConfigurationException {
        this.load(new InputStreamReader(stream, this.options().charset()));
    }

    public void load(Reader reader) throws IOException, InvalidConfigurationException {
        try (BufferedReader input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            this.loadFromString(input.lines().map(line -> line + "\n").collect(Collectors.joining()));
        }
    }

    public abstract void loadFromString(@NotNull String var1) throws InvalidConfigurationException;

    @Override
    public FileConfigurationOptions options() {
        if (this.options == null) {
            this.options = new FileConfigurationOptions(this);
        }
        return (FileConfigurationOptions)this.options;
    }

    public void save(@NotNull File file) throws IOException {
        this.write(file, this.saveToString());
    }

    public void save(@NotNull String file) throws IOException {
        this.save(new File(file));
    }

    public abstract String saveToString() throws IOException;

    protected String buildHeader() {
        return "";
    }

    protected void write(File file, String data) throws IOException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.options().charset());){
            writer.write(data);
        }
    }
}

