/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;
import top.wboost.common.base.enums.CharsetEnum;
import top.wboost.common.util.SystemUtil;

public class FileUtil {
    private static Logger log = Logger.getLogger(FileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFile(File file, byte[] bytes) {
        FileOutputStream outputStream = null;
        BufferedOutputStream bis = null;
        try {
            outputStream = new FileOutputStream(file);
            bis = new BufferedOutputStream(outputStream);
            ((OutputStream)outputStream).write(bytes);
        }
        catch (Exception e) {
            block9: {
                try {
                    if (e instanceof FileNotFoundException) {
                        if (!file.exists()) {
                            if (!file.getParentFile().exists()) {
                                file.getParentFile().mkdirs();
                            }
                            try {
                                file.createNewFile();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        FileUtil.exportFile(file, bytes);
                        break block9;
                    }
                    log.error((Object)("\u5199\u51fa\u6587\u4ef6\u51fa\u9519,\u539f\u56e0\u4e3a:" + e));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bis);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)bis);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        IOUtils.closeQuietly((OutputStream)bis);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static void exportFileToClasspath(String path, byte[] bytes) {
        String realPath = FileUtil.class.getResource("/").getPath() + path;
        File createFile = new File(realPath.replace("/", SystemUtil.FILE_SEPARATOR).replace("\\", SystemUtil.FILE_SEPARATOR));
        FileUtil.exportFile(createFile, bytes);
    }

    public static void exportFileToProject(String path, byte[] bytes) {
        String filePath = FileUtil.class.getResource("/").getPath();
        String realPath = new File(filePath).getParentFile().getParentFile().getPath() + path;
        File createFile = new File(realPath.replace("/", SystemUtil.FILE_SEPARATOR).replace("\\", SystemUtil.FILE_SEPARATOR));
        FileUtil.exportFile(createFile, bytes);
    }

    public static String importFileFromProject(String path) {
        String filePath = FileUtil.class.getResource("/").getPath();
        String realPath = new File(filePath).getParentFile().getParentFile().getPath() + path;
        File createFile = new File(realPath.replace("/", SystemUtil.FILE_SEPARATOR).replace("\\", SystemUtil.FILE_SEPARATOR));
        return FileUtil.importFile(createFile);
    }

    public static String importFileFromClasspath(String path) {
        String realPath = FileUtil.class.getResource("/").getPath() + path;
        File createFile = new File(realPath.replace("/", SystemUtil.FILE_SEPARATOR).replace("\\", SystemUtil.FILE_SEPARATOR));
        return FileUtil.importFile(createFile);
    }

    public static String importFile(File file) {
        try {
            return FileUtil.importFile(new FileInputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String importFile(File file, CharsetEnum charset) {
        try {
            return FileUtil.importFile(new FileInputStream(file), charset);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String importFile(MultipartFile file) {
        try {
            return FileUtil.importFile(file.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String importFile(MultipartFile file, CharsetEnum charset) {
        try {
            return FileUtil.importFile(file.getInputStream(), charset);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String importFile(InputStream inputStream) {
        return FileUtil.importFile(inputStream, CharsetEnum.ISO_8859_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String importFile(InputStream inputStream, CharsetEnum charset) {
        BufferedInputStream bis = null;
        StringBuffer stringBuffer = null;
        try {
            bis = new BufferedInputStream(inputStream);
            int len = 0;
            byte[] b = new byte[1024];
            stringBuffer = new StringBuffer();
            while ((len = bis.read(b)) != -1) {
                stringBuffer.append(new String(b, 0, len, charset.getName()));
            }
        }
        catch (Exception e) {
            try {
                log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519\uff0c\u539f\u56e0\u4e3a:" + e));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bis);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)inputStream);
        return stringBuffer.toString();
    }

    public static byte[] importFileBytes(File file) {
        try {
            return FileUtil.importFileBytes(new FileInputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] importFileBytes(InputStream inputStream) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int len = 0;
            while ((len = inputStream.read()) != -1) {
                bos.write(len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)bos);
        }
        return bos.toByteArray();
    }

    public static String importFileNio(FileInputStream inputStream, CharsetEnum charset) {
        byte[] result = null;
        try (FileChannel channel = inputStream.getChannel();){
            long allByteLength = channel.size();
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            int nowByteLength = 0;
            result = new byte[Integer.parseInt(String.valueOf(allByteLength))];
            while (channel.read(byteBuffer) != -1) {
                int position = byteBuffer.position();
                System.arraycopy(byteBuffer.array(), 0, result, nowByteLength, position);
                nowByteLength += position;
                byteBuffer.clear();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(result, charset.getCharset());
    }

    public static List<String> importText(String path) {
        File file = new File(path);
        try {
            return FileUtil.importText(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> importText(InputStream inputStream) {
        InputStreamReader reader = null;
        BufferedReader br = null;
        ArrayList<String> list = null;
        try {
            reader = new InputStreamReader(inputStream);
            br = new BufferedReader(reader);
            list = new ArrayList<String>();
            String str = "";
            while ((str = br.readLine()) != null) {
                list.add(new String(str.getBytes(), CharsetEnum.ISO_8859_1.getCharset()));
            }
        }
        catch (Exception e) {
            try {
                log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519\uff0c\u539f\u56e0\u4e3a:" + e));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly((Reader)reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)br);
            IOUtils.closeQuietly((Reader)reader);
        }
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((Reader)reader);
        return list;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(FileUtil.importFileNio(new FileInputStream(new File("C:\\Users\\jwsun\\Desktop\\json.txt")), CharsetEnum.UTF_8).replaceAll("(\r\n|\r|\n|\n\r|\t)", "").replaceAll("\\s+", ""));
    }
}

