/*
 * Decompiled with CFR 0.152.
 */
package com.chinaoly.resourcecatalog.standardcatalog.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final String EMPTY = "";
    private static final String DEFAULT_SHEET_NAME = "Sheet1";
    private static final int DEFAULT_BEGIN_ROW = -1;
    private static Integer sheetColumnWidth;

    public static void setSheetColumnWidth(Integer sheetColumnWidth) {
        ExcelUtil.sheetColumnWidth = sheetColumnWidth;
    }

    public static List<Map<String, String>> importExcel(MultipartFile file) throws Exception {
        return ExcelUtil.readExcel(file.getInputStream());
    }

    public static List<Map<String, String>> readExcel(InputStream fileStream) throws Exception {
        return ExcelUtil.readExcel(fileStream, -1);
    }

    public static List<Map<String, String>> readExcel(InputStream fileStream, Integer beginRow) throws Exception {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Workbook workbook = WorkbookFactory.create((InputStream)fileStream);
        int sheetNum = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetNum; ++i) {
            Row row;
            int lastRow;
            Sheet sheet = workbook.getSheetAt(i);
            if (beginRow == -1) {
                beginRow = sheet.getFirstRowNum();
            }
            if ((lastRow = sheet.getLastRowNum()) == 0 && beginRow == 0 && (row = sheet.getRow(0)) == null) continue;
            list.addAll(ExcelUtil.readExcel(beginRow, lastRow, sheet));
        }
        return list;
    }

    public static Map<String, List<Map<String, String>>> readExcelFromSheets(InputStream fileStream) throws Exception {
        return ExcelUtil.readExcelFromSheets(fileStream, -1);
    }

    public static Map<String, List<Map<String, String>>> readExcelFromSheets(InputStream fileStream, Integer beginRow) throws Exception {
        Workbook workbook = WorkbookFactory.create((InputStream)fileStream);
        HashMap<String, List<Map<String, String>>> sheetsMap = new HashMap<String, List<Map<String, String>>>();
        int sheetNum = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetNum; ++i) {
            Row row;
            int lastRow;
            Sheet sheet = workbook.getSheetAt(i);
            if (beginRow == -1) {
                beginRow = sheet.getFirstRowNum();
            }
            if ((lastRow = sheet.getLastRowNum()) == 0 && beginRow == 0 && (row = sheet.getRow(0)) == null) continue;
            sheetsMap.put(sheet.getSheetName(), ExcelUtil.readExcel(beginRow, lastRow, sheet));
        }
        return sheetsMap;
    }

    private static List<Map<String, String>> readExcel(int beginRow, int lastRow, Sheet sheet) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int j = beginRow; j <= lastRow; ++j) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            Row row = sheet.getRow(j);
            if (null == row) continue;
            list.add(map);
            for (int k = row.getFirstCellNum(); k < row.getLastCellNum(); ++k) {
                Cell cell = row.getCell(k);
                if (cell == null) {
                    map.put(String.valueOf(k), EMPTY);
                    continue;
                }
                map.put(String.valueOf(k), row.getCell(k).toString());
            }
        }
        return list;
    }

    public static void exportExcelToHtml(List<Map<String, Object>> list, String[] titles, String[] titleCode, String fileName, HttpServletResponse response) {
        ExcelUtil.exportExcelToHtml(list, titles, titleCode, fileName, DEFAULT_SHEET_NAME, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportExcelToHtml(List<Map<String, Object>> list, String[] titles, String[] titleCode, String fileName, String sheetName, HttpServletResponse response) {
        WritableWorkbook workbook = null;
        OutputStream os = null;
        try {
            response.setContentType("application/ms-excel;charset=utf-8");
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8") + ".xls");
            os = response.getOutputStream();
            workbook = jxl.Workbook.createWorkbook((OutputStream)os);
            WritableSheet sheet = workbook.createSheet(sheetName, 0);
            sheet.getSettings().setDefaultColumnWidth(20);
            for (int i = 0; i < titles.length; ++i) {
                Label label = new Label(i, 0, titles[i]);
                sheet.addCell((WritableCell)label);
            }
            if (null == list || list.size() == 0) {
                workbook.write();
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> map = list.get(i);
                for (int j = 0; j < titles.length; ++j) {
                    Label label = null;
                    Object param = map.get(titleCode[j]);
                    if (map.get(titleCode[j]) != null || titleCode[j] != null) {
                        Number number = null;
                        if (param instanceof Integer) {
                            int value = (Integer)param;
                            number = new Number(j, i + 1, (double)value);
                            sheet.addCell((WritableCell)number);
                            continue;
                        }
                        if (param instanceof String) {
                            String s = (String)param;
                            if ("price".equals(titleCode[j]) || "chrate".equals(titleCode[j])) {
                                int n = Integer.parseInt(s);
                                number = new Number(j, i + 1, (double)n);
                                sheet.addCell((WritableCell)number);
                                continue;
                            }
                            label = new Label(j, i + 1, s);
                            sheet.addCell((WritableCell)label);
                            continue;
                        }
                        if (param instanceof Double) {
                            double d = (Double)param;
                            number = new Number(j, i + 1, d);
                            sheet.addCell((WritableCell)number);
                            continue;
                        }
                        if (param instanceof Float) {
                            float f = ((Float)param).floatValue();
                            number = new Number(j, i + 1, (double)f);
                            sheet.addCell((WritableCell)number);
                            continue;
                        }
                        if (param instanceof Long) {
                            long l = (Long)param;
                            number = new Number(j, i + 1, (double)l);
                            sheet.addCell((WritableCell)number);
                            continue;
                        }
                        if (param instanceof BigDecimal) {
                            long b = ((BigDecimal)param).longValue();
                            number = new Number(j, i + 1, (double)b);
                            sheet.addCell((WritableCell)number);
                            continue;
                        }
                        if (!(param instanceof Date)) continue;
                        Date date = (Date)param;
                        String newDate = dateFormat.format(date);
                        label = new Label(j, i + 1, newDate);
                        sheet.addCell((WritableCell)label);
                        continue;
                    }
                    label = new Label(j, i + 1, EMPTY);
                    sheet.addCell((WritableCell)label);
                }
            }
            workbook.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (workbook != null) {
                    workbook.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void axleDraw(List<Map<String, String>> dataSource, OutputStream os) {
        ExcelUtil.axleDraw(dataSource, null, os, DEFAULT_SHEET_NAME, new ArrayList<String[]>());
    }

    public static void axleDraw(List<Map<String, String>> dataSource, OutputStream os, String sheetName) {
        ExcelUtil.axleDraw(dataSource, null, os, sheetName, new ArrayList<String[]>());
    }

    public static void axleDraw(List<Map<String, String>> dataSource, OutputStream os, List<String[]> titles) {
        ExcelUtil.axleDraw(dataSource, null, os, DEFAULT_SHEET_NAME, titles);
    }

    public static void axleDraw(List<Map<String, String>> dataSource, OutputStream os, String sheetName, List<String[]> titles) {
        ExcelUtil.axleDraw(dataSource, null, os, sheetName, titles);
    }

    public static void axleDraw(List<Map<String, String>> dataSource, Map<String, Object> remarkSource, OutputStream os) {
        ExcelUtil.axleDraw(dataSource, remarkSource, os, DEFAULT_SHEET_NAME, new ArrayList<String[]>());
    }

    public static void axleDraw(List<Map<String, String>> dataSource, Map<String, Object> remarkSource, OutputStream os, String sheetName) {
        ExcelUtil.axleDraw(dataSource, remarkSource, os, sheetName, new ArrayList<String[]>());
    }

    public static void axleDraw(List<Map<String, String>> dataSource, Map<String, Object> remarkSource, OutputStream os, List<String[]> titles) {
        ExcelUtil.axleDraw(dataSource, remarkSource, os, DEFAULT_SHEET_NAME, titles);
    }

    public static void axleDraw(List<Map<String, String>> dataSource, Map<String, Object> remarkSource, OutputStream os, String sheetName, List<String[]> titles) {
        HashMap<String, List<String[]>> titles_map = new HashMap<String, List<String[]>>();
        titles_map.put(sheetName, titles);
        HashMap<String, List<Map<String, String>>> dataSource_map = new HashMap<String, List<Map<String, String>>>();
        dataSource_map.put(sheetName, dataSource);
        HashMap<String, Map<String, Object>> remarkSource_map = new HashMap<String, Map<String, Object>>();
        remarkSource_map.put(sheetName, remarkSource);
        ExcelUtil.axleDraw(dataSource_map, remarkSource_map, os, new String[]{sheetName}, titles_map);
    }

    public static void axleDraw(Map<String, List<Map<String, String>>> dataSource, OutputStream os) {
        HashMap<String, List<String[]>> titles = new HashMap<String, List<String[]>>();
        String[] sheetNames = new String[dataSource.size()];
        int i = 0;
        for (String key : dataSource.keySet()) {
            sheetNames[i++] = key;
            titles.put(key, new ArrayList());
        }
        ExcelUtil.axleDraw(dataSource, null, os, sheetNames, titles);
    }

    public static void axleDraw(Map<String, List<Map<String, String>>> dataSource, OutputStream os, String[] sheetNames) {
        HashMap<String, List<String[]>> titles = new HashMap<String, List<String[]>>();
        for (String sheetName : sheetNames) {
            titles.put(sheetName, new ArrayList());
        }
        ExcelUtil.axleDraw(dataSource, null, os, sheetNames, titles);
    }

    public static void axleDraw(Map<String, List<Map<String, String>>> dataSource, OutputStream os, Map<String, List<String[]>> titles) {
        ExcelUtil.axleDraw(dataSource, null, os, (String[])dataSource.keySet().toArray(), titles);
    }

    public static void axleDraw(Map<String, List<Map<String, String>>> dataSource, OutputStream os, String[] sheetNames, Map<String, List<String[]>> titles) {
        ExcelUtil.axleDraw(dataSource, null, os, sheetNames, titles);
    }

    public static void axleDraw(Map<String, List<Map<String, String>>> dataSource, Map<String, Map<String, Object>> remarkSource, OutputStream os) {
        HashMap<String, List<String[]>> titles = new HashMap<String, List<String[]>>();
        String[] sheetNames = new String[dataSource.size()];
        int i = 0;
        for (String key : dataSource.keySet()) {
            sheetNames[i++] = key;
            titles.put(key, new ArrayList());
        }
        ExcelUtil.axleDraw(dataSource, remarkSource, os, sheetNames, titles);
    }

    public static void axleDraw(Map<String, List<Map<String, String>>> dataSource, Map<String, Map<String, Object>> remarkSource, OutputStream os, String[] sheetNames) {
        HashMap<String, List<String[]>> titles = new HashMap<String, List<String[]>>();
        for (String sheetName : sheetNames) {
            titles.put(sheetName, new ArrayList());
        }
        ExcelUtil.axleDraw(dataSource, remarkSource, os, sheetNames, titles);
    }

    public static void axleDraw(Map<String, List<Map<String, String>>> dataSource, Map<String, Map<String, Object>> remarkSource, OutputStream os, Map<String, List<String[]>> titles) {
        ExcelUtil.axleDraw(dataSource, remarkSource, os, (String[])dataSource.keySet().toArray(), titles);
    }

    public static void axleDraw(Map<String, List<Map<String, String>>> dataSource, Map<String, Map<String, Object>> remarkSource, OutputStream os, String[] sheetNames, Map<String, List<String[]>> titles) {
        Workbook wb = ExcelUtil.createWorkbook(sheetNames, titles);
        ExcelUtil.axleDraw(dataSource, remarkSource, os, wb, titles);
    }

    public static void axleDraw(Map<String, List<Map<String, String>>> dataSource, Map<String, Map<String, Object>> remarkSource, OutputStream os, Workbook wb, Map<String, List<String[]>> titles) {
        try {
            ExcelUtil.createFixationSheet(dataSource, remarkSource, os, wb, titles);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createFixationSheet(Map<String, List<Map<String, String>>> dataSource, Map<String, Map<String, Object>> remarkSource, OutputStream os, Workbook wb, Map<String, List<String[]>> titles) throws IOException {
        CellStyle style = ExcelUtil.createCellRedStyle(wb);
        for (String sheetKey : dataSource.keySet()) {
            if (!ExcelUtil.containsSheet(wb, sheetKey).booleanValue()) {
                ExcelUtil.createSheet(wb, sheetKey);
            }
            Sheet sheet = wb.getSheet(sheetKey);
            List<Map<String, String>> list = dataSource.get(sheetKey);
            for (int i = 0; !list.isEmpty() && i < list.size(); ++i) {
                int rowNum = titles.containsKey(sheetKey) ? i + titles.get(sheetKey).size() : i;
                Map<String, String> rowData = list.get(i);
                Row row = sheet.createRow(rowNum);
                for (String key : rowData.keySet()) {
                    Map<String, Object> map;
                    Cell cell = row.createCell(Integer.valueOf(key).intValue());
                    cell.setCellValue(rowData.get(key));
                    if (null == remarkSource || remarkSource.isEmpty() || !remarkSource.containsKey(sheetKey) || (map = remarkSource.get(sheetKey)).isEmpty() || !map.containsKey(rowNum + "," + key)) continue;
                    cell.setCellStyle(style);
                }
            }
        }
        wb.write(os);
        os.flush();
        os.close();
    }

    public static OutputStream setResponseHeader(HttpServletResponse response, String fileName) throws IOException {
        response.setContentType("application/ms-excel;charset=utf-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8") + ".xls");
        return response.getOutputStream();
    }

    public static Workbook createWorkbook() {
        return ExcelUtil.createWorkbook(DEFAULT_SHEET_NAME, new ArrayList<String[]>());
    }

    public static Workbook createWorkbook(String sheetName) {
        return ExcelUtil.createWorkbook(sheetName, new ArrayList<String[]>());
    }

    public static Workbook createWorkbook(List<String[]> titles) {
        return ExcelUtil.createWorkbook(DEFAULT_SHEET_NAME, titles);
    }

    public static Workbook createWorkbook(String sheetName, List<String[]> titles) {
        HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
        map.put(sheetName, titles);
        return ExcelUtil.createWorkbook(new String[]{sheetName}, map);
    }

    public static Workbook createWorkbook(String[] sheetNames) {
        HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
        for (String sheetName : sheetNames) {
            map.put(sheetName, new ArrayList());
        }
        return ExcelUtil.createWorkbook(sheetNames, map);
    }

    public static Workbook createWorkbook(Map<String, List<String[]>> titles) {
        String[] sheetNames = new String[titles.size()];
        int i = 0;
        for (String key : titles.keySet()) {
            sheetNames[i++] = key;
        }
        return ExcelUtil.createWorkbook(sheetNames, titles);
    }

    public static Workbook createWorkbook(String[] sheetName, Map<String, List<String[]>> titles) {
        HSSFWorkbook wb = new HSSFWorkbook();
        ExcelUtil.createSheet((Workbook)wb, sheetName, titles);
        return wb;
    }

    public static void createSheet(Workbook wb, String sheetName) {
        wb.createSheet(sheetName);
    }

    public static void createSheet(Workbook wb, String[] sheetNames, Map<String, List<String[]>> titles) {
        CellStyle cellStyle = ExcelUtil.createFontTextStyle(wb);
        for (String sheetName : sheetNames) {
            int i;
            Sheet sheet = wb.createSheet(sheetName);
            if (!titles.containsKey(sheetName)) continue;
            List<String[]> title = titles.get(sheetName);
            if (titles.isEmpty()) continue;
            for (i = 0; i < title.get(0).length; ++i) {
                sheet.setDefaultColumnStyle(i, cellStyle);
                if (sheetColumnWidth == null || sheetColumnWidth <= 0) {
                    sheetColumnWidth = 7800;
                }
                sheet.setColumnWidth(i, sheetColumnWidth.intValue());
            }
            for (i = 0; i < title.size(); ++i) {
                Row title_row = sheet.createRow(i);
                for (int j = 0; j < title.get(i).length; ++j) {
                    Cell cell = title_row.createCell(j);
                    cell.setCellValue(title.get(i)[j]);
                }
            }
        }
    }

    private static CellStyle createCellRedStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setFillPattern((short)1);
        style.setFillForegroundColor((short)10);
        return style;
    }

    private static CellStyle createFontTextStyle(Workbook wb) {
        CellStyle cellStyle = wb.createCellStyle();
        DataFormat format = wb.createDataFormat();
        cellStyle.setDataFormat(format.getFormat("@"));
        return cellStyle;
    }

    public static Boolean containsSheet(Workbook wb, String sheetName) {
        return wb.getSheet(sheetName) != null;
    }
}

