/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.boot.handler;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.hutool.core.util.StrUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import top.tangyh.basic.base.R;
import top.tangyh.basic.exception.ArgumentException;
import top.tangyh.basic.exception.BizException;
import top.tangyh.basic.exception.ForbiddenException;
import top.tangyh.basic.exception.UnauthorizedException;
import top.tangyh.basic.exception.code.ExceptionCode;

public abstract class AbstractGlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGlobalExceptionHandler.class);
    @Value(value="${spring.profiles.active:dev}")
    protected String profiles;

    @ExceptionHandler(value={BizException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> bizException(BizException ex) {
        log.warn("BizException: path = {}", (Object)this.getPath(), (Object)ex);
        return R.result((int)ex.getCode(), null, (String)ex.getMessage()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={SaTokenException.class})
    public R<?> handlerSaTokenException(SaTokenException e) {
        log.warn("SaTokenException: path = {}", (Object)this.getPath(), (Object)e);
        return R.result((int)e.getCode(), null, (String)e.getMessage()).setErrorMsg(this.getErrorMsg((Exception)e)).setPath(this.getPath());
    }

    @ExceptionHandler(value={NotLoginException.class})
    public R<?> handlerNotLoginException(NotLoginException nle) throws Exception {
        log.warn("NotLoginException: path =  {}", (Object)this.getPath(), (Object)nle);
        String message = "";
        message = nle.getType().equals("-1") ? "\u672a\u80fd\u8bfb\u53d6\u5230\u6709\u6548 token" : (nle.getType().equals("-2") ? "token \u65e0\u6548" : (nle.getType().equals("-3") ? "token \u5df2\u8fc7\u671f" : (nle.getType().equals("-4") ? "token \u5df2\u88ab\u9876\u4e0b\u7ebf" : (nle.getType().equals("-5") ? "token \u5df2\u88ab\u8e22\u4e0b\u7ebf" : (nle.getType().equals("-6") ? "token \u5df2\u88ab\u51bb\u7ed3" : (nle.getType().equals("-7") ? "\u672a\u6309\u7167\u6307\u5b9a\u524d\u7f00\u63d0\u4ea4 token" : "\u5f53\u524d\u4f1a\u8bdd\u672a\u767b\u5f55"))))));
        return R.result((int)nle.getCode(), null, (String)message).setErrorMsg(this.getErrorMsg((Exception)nle)).setPath(this.getPath());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ArgumentException.class})
    public R<?> bizException(ArgumentException ex) {
        log.warn("ArgumentException:", (Throwable)ex);
        return R.result((int)ex.getCode(), null, (String)ex.getMessage()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={ForbiddenException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public R<?> forbiddenException(ForbiddenException ex) {
        log.warn("BizException:", (Throwable)ex);
        return R.result((int)ex.getCode(), null, (String)ex.getMessage()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public R<?> unauthorizedException(UnauthorizedException ex) {
        log.warn("BizException:", (Throwable)ex);
        return R.result((int)ex.getCode(), null, (String)ex.getMessage()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> httpMessageNotReadableException(HttpMessageNotReadableException ex) {
        log.warn("HttpMessageNotReadableException:", (Throwable)ex);
        String message = ex.getMessage();
        if (StrUtil.containsAny((CharSequence)message, (CharSequence[])new CharSequence[]{"Could not read document:"})) {
            String msg = String.format("\u65e0\u6cd5\u6b63\u786e\u7684\u89e3\u6790json\u7c7b\u578b\u7684\u53c2\u6570\uff1a%s", StrUtil.subBetween((CharSequence)message, (CharSequence)"Could not read document:", (CharSequence)" at "));
            return R.result((int)ExceptionCode.PARAM_EX.getCode(), null, (String)msg, (String)ex.getMessage()).setPath(this.getPath());
        }
        return R.result((int)ExceptionCode.PARAM_EX.getCode(), null, (String)ExceptionCode.PARAM_EX.getMsg()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> bindException(BindException ex) {
        CharSequence msg;
        log.warn("BindException:", (Throwable)ex);
        try {
            msg = Objects.requireNonNull(ex.getBindingResult().getFieldError()).getDefaultMessage();
            if (StrUtil.isNotEmpty((CharSequence)msg)) {
                return R.result((int)ExceptionCode.PARAM_EX.getCode(), null, (String)msg, (String)ex.getMessage()).setPath(this.getPath());
            }
        }
        catch (Exception ee) {
            log.debug("\u83b7\u53d6\u5f02\u5e38\u63cf\u8ff0\u5931\u8d25", (Throwable)ee);
        }
        msg = new StringBuilder();
        List fieldErrors = ex.getFieldErrors();
        fieldErrors.forEach(arg_0 -> AbstractGlobalExceptionHandler.lambda$bindException$0((StringBuilder)msg, arg_0));
        return R.result((int)ExceptionCode.PARAM_EX.getCode(), null, (String)((StringBuilder)msg).toString()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> methodArgumentTypeMismatchException(MethodArgumentTypeMismatchException ex) {
        log.warn("MethodArgumentTypeMismatchException:", (Throwable)ex);
        String msg = "\u53c2\u6570\uff1a[" + ex.getName() + "]\u7684\u4f20\u5165\u503c\uff1a[" + ex.getValue() + "]\u4e0e\u9884\u671f\u7684\u5b57\u6bb5\u7c7b\u578b\uff1a[" + Objects.requireNonNull(ex.getRequiredType()).getName() + "]\u4e0d\u5339\u914d";
        return R.result((int)ExceptionCode.PARAM_EX.getCode(), null, (String)msg).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> illegalStateException(IllegalStateException ex) {
        log.warn("IllegalStateException:", (Throwable)ex);
        return R.result((int)ExceptionCode.ILLEGAL_ARGUMENT_EX.getCode(), null, (String)ExceptionCode.ILLEGAL_ARGUMENT_EX.getMsg()).setErrorMsg(this.getErrorMsg(ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> missingServletRequestParameterException(MissingServletRequestParameterException ex) {
        log.warn("MissingServletRequestParameterException:", (Throwable)ex);
        return R.result((int)ExceptionCode.ILLEGAL_ARGUMENT_EX.getCode(), null, (String)("\u7f3a\u5c11\u5fc5\u987b\u7684[" + ex.getParameterType() + "]\u7c7b\u578b\u7684\u53c2\u6570[" + ex.getParameterName() + "]")).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> nullPointerException(NullPointerException ex) {
        log.warn("NullPointerException:", (Throwable)ex);
        return R.result((int)ExceptionCode.NULL_POINT_EX.getCode(), null, (String)ExceptionCode.NULL_POINT_EX.getMsg()).setErrorMsg(this.getErrorMsg(ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> illegalArgumentException(IllegalArgumentException ex) {
        log.warn("IllegalArgumentException:", (Throwable)ex);
        return R.result((int)ExceptionCode.ILLEGAL_ARGUMENT_EX.getCode(), null, (String)ExceptionCode.ILLEGAL_ARGUMENT_EX.getMsg()).setErrorMsg(this.getErrorMsg(ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> httpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException ex) {
        log.warn("HttpMediaTypeNotSupportedException:", (Throwable)ex);
        MediaType contentType = ex.getContentType();
        if (contentType != null) {
            return R.result((int)ExceptionCode.MEDIA_TYPE_EX.getCode(), null, (String)("\u8bf7\u6c42\u7c7b\u578b(Content-Type)[" + contentType + "] \u4e0e\u5b9e\u9645\u63a5\u53e3\u7684\u8bf7\u6c42\u7c7b\u578b\u4e0d\u5339\u914d"), (String)ex.getMessage()).setPath(this.getPath());
        }
        return R.result((int)ExceptionCode.MEDIA_TYPE_EX.getCode(), null, (String)"\u65e0\u6548\u7684Content-Type\u7c7b\u578b").setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={MissingServletRequestPartException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> missingServletRequestPartException(MissingServletRequestPartException ex) {
        log.warn("MissingServletRequestPartException:", (Throwable)ex);
        return R.result((int)ExceptionCode.REQUIRED_FILE_PARAM_EX.getCode(), null, (String)ExceptionCode.REQUIRED_FILE_PARAM_EX.getMsg()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={ServletException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> servletException(ServletException ex) {
        log.warn("ServletException:", (Throwable)ex);
        String msg = "UT010016: Not a multi part request";
        if (msg.equalsIgnoreCase(ex.getMessage())) {
            return R.result((int)ExceptionCode.REQUIRED_FILE_PARAM_EX.getCode(), null, (String)ExceptionCode.REQUIRED_FILE_PARAM_EX.getMsg(), (String)ex.getMessage());
        }
        return R.result((int)ExceptionCode.SYSTEM_BUSY.getCode(), null, (String)ex.getMessage()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={MultipartException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> multipartException(MultipartException ex) {
        log.warn("MultipartException:", (Throwable)ex);
        return R.result((int)ExceptionCode.REQUIRED_FILE_PARAM_EX.getCode(), null, (String)ExceptionCode.REQUIRED_FILE_PARAM_EX.getMsg()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> constraintViolationException(ConstraintViolationException ex) {
        log.warn("ConstraintViolationException:", (Throwable)ex);
        Set violations = ex.getConstraintViolations();
        String message = violations.stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(";"));
        return R.result((int)ExceptionCode.BASE_VALID_PARAM.getCode(), null, (String)message).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> methodArgumentNotValidException(MethodArgumentNotValidException ex) {
        log.warn("MethodArgumentNotValidException:", (Throwable)ex);
        return R.result((int)ExceptionCode.BASE_VALID_PARAM.getCode(), null, (String)Objects.requireNonNull(ex.getBindingResult().getFieldError()).getDefaultMessage()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> otherExceptionHandler(Exception ex) {
        log.warn("Exception:", (Throwable)ex);
        Throwable throwable = ex.getCause();
        if (throwable instanceof BizException) {
            BizException cause = (BizException)throwable;
            return this.bizException(cause);
        }
        return R.result((int)ExceptionCode.SYSTEM_BUSY.getCode(), null, (String)ExceptionCode.SYSTEM_BUSY.getMsg()).setErrorMsg(this.getErrorMsg(ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException ex) {
        log.warn("HttpRequestMethodNotSupportedException:", (Throwable)ex);
        return R.result((int)ExceptionCode.METHOD_NOT_ALLOWED.getCode(), null, (String)ExceptionCode.METHOD_NOT_ALLOWED.getMsg()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={PersistenceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> persistenceException(PersistenceException ex) {
        log.warn("PersistenceException:", (Throwable)ex);
        Throwable throwable = ex.getCause();
        if (throwable instanceof BizException) {
            BizException cause = (BizException)throwable;
            return R.result((int)cause.getCode(), null, (String)cause.getMessage());
        }
        return R.result((int)ExceptionCode.SQL_EX.getCode(), null, (String)ExceptionCode.SQL_EX.getMsg()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={MyBatisSystemException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> myBatisSystemException(MyBatisSystemException ex) {
        log.warn("PersistenceException:", (Throwable)ex);
        Throwable throwable = ex.getCause();
        if (throwable instanceof PersistenceException) {
            PersistenceException cause = (PersistenceException)throwable;
            return this.persistenceException(cause);
        }
        return R.result((int)ExceptionCode.SQL_EX.getCode(), null, (String)ExceptionCode.SQL_EX.getMsg()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={SQLException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> sqlException(SQLException ex) {
        log.warn("SQLException:", (Throwable)ex);
        return R.result((int)ExceptionCode.SQL_EX.getCode(), null, (String)ExceptionCode.SQL_EX.getMsg()).setErrorMsg(this.getErrorMsg(ex)).setPath(this.getPath());
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<?> dataIntegrityViolationException(DataIntegrityViolationException ex) {
        log.warn("DataIntegrityViolationException:", (Throwable)ex);
        return R.result((int)ExceptionCode.SQL_EX.getCode(), null, (String)ExceptionCode.SQL_EX.getMsg()).setErrorMsg(this.getErrorMsg((Exception)ex)).setPath(this.getPath());
    }

    private String getPath() {
        String path = "";
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            path = request.getRequestURI();
        } else {
            log.warn("\u65e0\u6cd5\u83b7\u53d6 request");
        }
        return path;
    }

    private String getErrorMsg(Exception ex) {
        return "prod".equals(this.profiles) ? "" : ex.getLocalizedMessage();
    }

    private static /* synthetic */ void lambda$bindException$0(StringBuilder msg, FieldError oe) {
        msg.append("\u53c2\u6570:[").append(oe.getObjectName()).append(".").append(oe.getField()).append("]\u7684\u4f20\u5165\u503c:[").append(oe.getRejectedValue()).append("]\u4e0e\u9884\u671f\u7684\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d.");
    }
}

