/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.validator.component.extract;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Validator;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.internal.engine.ValidatorImpl;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.validator.component.extract.IConstraintExtract;
import top.tangyh.basic.validator.mateconstraint.IConstraintConverter;
import top.tangyh.basic.validator.mateconstraint.impl.DigitsConstraintConverter;
import top.tangyh.basic.validator.mateconstraint.impl.MaxMinConstraintConverter;
import top.tangyh.basic.validator.mateconstraint.impl.NotNullConstraintConverter;
import top.tangyh.basic.validator.mateconstraint.impl.OtherConstraintConverter;
import top.tangyh.basic.validator.mateconstraint.impl.RangeConstraintConverter;
import top.tangyh.basic.validator.mateconstraint.impl.RegExConstraintConverter;
import top.tangyh.basic.validator.model.ConstraintInfo;
import top.tangyh.basic.validator.model.FieldValidatorDesc;
import top.tangyh.basic.validator.model.ValidConstraint;

public class DefaultConstraintExtractImpl
implements IConstraintExtract {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultConstraintExtractImpl.class);
    private final Map<String, Map<String, FieldValidatorDesc>> CACHE = new HashMap<String, Map<String, FieldValidatorDesc>>();
    private final Validator validator;
    private BeanMetaDataManager beanMetaDataManager;
    private List<IConstraintConverter> constraintConverters;

    public DefaultConstraintExtractImpl(Validator validator) {
        this.validator = validator;
        this.init();
    }

    public final void init() {
        try {
            Field beanMetaDataManagerField = ValidatorImpl.class.getDeclaredField("beanMetaDataManager");
            beanMetaDataManagerField.setAccessible(true);
            this.beanMetaDataManager = (BeanMetaDataManager)beanMetaDataManagerField.get(this.validator);
            this.constraintConverters = new ArrayList<IConstraintConverter>(10);
            this.constraintConverters.add(new MaxMinConstraintConverter());
            this.constraintConverters.add(new NotNullConstraintConverter());
            this.constraintConverters.add(new RangeConstraintConverter());
            this.constraintConverters.add(new DigitsConstraintConverter());
            this.constraintConverters.add(new RegExConstraintConverter());
            this.constraintConverters.add(new OtherConstraintConverter());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error("\u521d\u59cb\u5316\u9a8c\u8bc1\u5668\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public Collection<FieldValidatorDesc> extract(List<ValidConstraint> constraints) throws Exception {
        if (constraints == null || constraints.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, FieldValidatorDesc> fieldValidatorDesc = new HashMap<String, FieldValidatorDesc>((int)((double)constraints.size() / 0.75 + 1.0));
        for (ValidConstraint constraint : constraints) {
            this.doExtract(constraint, fieldValidatorDesc);
        }
        return fieldValidatorDesc.values();
    }

    private void doExtract(ValidConstraint constraint, Map<String, FieldValidatorDesc> fieldValidatorDesc) throws Exception {
        Class<?> targetClazz = constraint.getTarget();
        Class<?>[] groups = constraint.getGroups();
        String key = targetClazz.getName() + ":" + Arrays.stream(groups).map(Class::getName).collect(Collectors.joining(":"));
        if (this.CACHE.containsKey(key)) {
            fieldValidatorDesc.putAll(this.CACHE.get(key));
            return;
        }
        BeanMetaData res = this.beanMetaDataManager.getBeanMetaData(targetClazz);
        Set r = res.getMetaConstraints();
        Set constrainedProperties = res.getBeanDescriptor().getConstrainedProperties();
        for (MetaConstraint metaConstraint : r) {
            this.builderFieldValidatorDesc(metaConstraint, constrainedProperties, groups, fieldValidatorDesc);
        }
        this.CACHE.put(key, fieldValidatorDesc);
    }

    private void builderFieldValidatorDesc(MetaConstraint<?> metaConstraint, Set<PropertyDescriptor> constraintDescriptors, Class<?>[] groups, Map<String, FieldValidatorDesc> fieldValidatorDesc) throws Exception {
        Set groupsMeta = metaConstraint.getGroupList();
        boolean isContainsGroup = false;
        block0: for (Class<?> group : groups) {
            if (groupsMeta.contains(group)) {
                isContainsGroup = true;
                break;
            }
            for (Object g : groupsMeta) {
                if (!((Class)g).isAssignableFrom(group)) continue;
                isContainsGroup = true;
                continue block0;
            }
        }
        if (!isContainsGroup) {
            return;
        }
        ConstraintLocation con = metaConstraint.getLocation();
        String domainName = con.getDeclaringClass().getSimpleName();
        String fieldName = con.getConstrainable().getName();
        String key = domainName + fieldName;
        boolean flag = false;
        for (PropertyDescriptor constraintDescriptor : constraintDescriptors) {
            if (!constraintDescriptor.getPropertyName().equals(fieldName)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return;
        }
        FieldValidatorDesc desc = fieldValidatorDesc.get(key);
        if (desc == null) {
            desc = new FieldValidatorDesc();
            Field field = ReflectUtil.getField((Class)con.getDeclaringClass(), (String)fieldName);
            if (field != null) {
                Schema schema = field.getAnnotation(Schema.class);
                String name = schema != null && StrUtil.isNotEmpty((CharSequence)schema.description()) ? schema.description() : fieldName;
                desc.setName(name);
            } else {
                desc.setName(fieldName);
            }
            desc.setField(fieldName);
            desc.setFieldType(this.getType(con.getConstrainable().getType().getTypeName()));
            desc.setConstraints(new ArrayList<ConstraintInfo>());
            fieldValidatorDesc.put(key, desc);
        }
        ConstraintInfo constraint = this.builderConstraint(metaConstraint.getDescriptor().getAnnotation());
        desc.getConstraints().add(constraint);
        if ("Pattern".equals(metaConstraint.getDescriptor().getAnnotationType().getSimpleName())) {
            ConstraintInfo notNull = new ConstraintInfo();
            notNull.setType("NotNull");
            HashMap attrs = MapUtil.newHashMap();
            attrs.put("message", "\u4e0d\u80fd\u4e3a\u7a7a");
            notNull.setAttrs(attrs);
            desc.getConstraints().add(notNull);
        }
    }

    private String getType(String typeName) {
        if (StrUtil.startWithAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{"java.util.Set", "java.util.List", "java.util.Collection"})) {
            return "Array";
        }
        if (StrUtil.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{"java.lang.Long", "java.lang.Integer", "java.lang.Short"})) {
            return "Integer";
        }
        if (StrUtil.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{"java.lang.Double", "java.lang.Float"})) {
            return "Float";
        }
        if (StrUtil.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{"java.time.LocalDateTime", "java.util.Date"})) {
            return "DateTime";
        }
        if (StrUtil.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{"java.time.LocalDate"})) {
            return "Date";
        }
        if (StrUtil.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{"java.time.LocalTime"})) {
            return "Time";
        }
        if (StrUtil.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{"java.lang.Boolean"})) {
            return "Boolean";
        }
        return StrUtil.subAfter((CharSequence)typeName, (char)'.', (boolean)true);
    }

    private ConstraintInfo builderConstraint(Annotation annotation) throws Exception {
        for (IConstraintConverter constraintConverter : this.constraintConverters) {
            if (!constraintConverter.support(annotation.annotationType())) continue;
            return constraintConverter.converter(annotation);
        }
        return null;
    }
}

