/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.fsg.uid.utils;

import cn.hutool.core.util.StrUtil;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DockerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerUtils.class);
    private static final String ENV_KEY_HOST = "JPAAS_HOST";
    private static final String ENV_KEY_PORT = "JPAAS_HTTP_PORT";
    private static final String ENV_KEY_PORT_ORIGINAL = "JPAAS_HOST_PORT_8080";
    private static String dockerHost = "";
    private static String dockerPort = "";
    private static boolean isDocker;

    private DockerUtils() {
    }

    public static boolean isDocker() {
        return isDocker;
    }

    private static void retrieveFromEnv() {
        dockerHost = System.getenv(ENV_KEY_HOST);
        dockerPort = System.getenv(ENV_KEY_PORT);
        if (StrUtil.isBlank((CharSequence)dockerPort)) {
            dockerPort = System.getenv(ENV_KEY_PORT_ORIGINAL);
        }
        boolean hasEnvHost = StrUtil.isNotBlank((CharSequence)dockerHost);
        boolean hasEnvPort = StrUtil.isNotBlank((CharSequence)dockerPort);
        if (hasEnvHost && hasEnvPort) {
            isDocker = true;
        } else if (!hasEnvHost && !hasEnvPort) {
            isDocker = false;
        } else {
            LOGGER.error("Missing host or port from env for Docker. host:{}, port:{}", (Object)dockerHost, (Object)dockerPort);
            throw new RuntimeException("Missing host or port from env for Docker. host:" + dockerHost + ", port:" + dockerPort);
        }
    }

    @Generated
    public static String getDockerHost() {
        return dockerHost;
    }

    @Generated
    public static String getDockerPort() {
        return dockerPort;
    }

    static {
        DockerUtils.retrieveFromEnv();
    }
}

