/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.fsg.uid.buffer;

import com.baidu.fsg.uid.buffer.BufferedUidProvider;
import com.baidu.fsg.uid.buffer.RingBuffer;
import com.baidu.fsg.uid.utils.NamingThreadFactory;
import com.baidu.fsg.uid.utils.PaddedAtomicLong;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class BufferPaddingExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RingBuffer.class);
    private static final String WORKER_NAME = "RingBuffer-Padding-Worker";
    private static final String SCHEDULE_NAME = "RingBuffer-Padding-Schedule";
    private static final long DEFAULT_SCHEDULE_INTERVAL = 300L;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final PaddedAtomicLong lastSecond = new PaddedAtomicLong(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
    private final RingBuffer ringBuffer;
    private final BufferedUidProvider uidProvider;
    private final ExecutorService bufferPadExecutors;
    private final ScheduledExecutorService bufferPadSchedule;
    private long scheduleInterval = 300L;

    public BufferPaddingExecutor(RingBuffer ringBuffer, BufferedUidProvider uidProvider) {
        this(ringBuffer, uidProvider, true);
    }

    public BufferPaddingExecutor(RingBuffer ringBuffer, BufferedUidProvider uidProvider, boolean usingSchedule) {
        this.ringBuffer = ringBuffer;
        this.uidProvider = uidProvider;
        int cores = Runtime.getRuntime().availableProcessors();
        this.bufferPadExecutors = Executors.newFixedThreadPool(cores * 2, new NamingThreadFactory(WORKER_NAME));
        this.bufferPadSchedule = usingSchedule ? Executors.newSingleThreadScheduledExecutor(new NamingThreadFactory(SCHEDULE_NAME)) : null;
    }

    public void start() {
        if (this.bufferPadSchedule != null) {
            this.bufferPadSchedule.scheduleWithFixedDelay(this::paddingBuffer, this.scheduleInterval, this.scheduleInterval, TimeUnit.SECONDS);
        }
    }

    public void shutdown() {
        if (!this.bufferPadExecutors.isShutdown()) {
            this.bufferPadExecutors.shutdownNow();
        }
        if (this.bufferPadSchedule != null && !this.bufferPadSchedule.isShutdown()) {
            this.bufferPadSchedule.shutdownNow();
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void asyncPadding() {
        this.bufferPadExecutors.submit(this::paddingBuffer);
    }

    public void paddingBuffer() {
        LOGGER.debug("Ready to padding buffer lastSecond:{}. {}", (Object)this.lastSecond.get(), (Object)this.ringBuffer);
        if (!this.running.compareAndSet(false, true)) {
            LOGGER.debug("Padding buffer is still running. {}", (Object)this.ringBuffer);
            return;
        }
        boolean isFullRingBuffer = false;
        while (!isFullRingBuffer) {
            Long uid;
            List<Long> uidList = this.uidProvider.provide(this.lastSecond.incrementAndGet());
            Iterator<Long> iterator = uidList.iterator();
            while (iterator.hasNext() && !(isFullRingBuffer = !this.ringBuffer.put(uid = iterator.next()))) {
            }
        }
        this.running.compareAndSet(true, false);
        LOGGER.debug("End to padding buffer lastSecond:{}. {}", (Object)this.lastSecond.get(), (Object)this.ringBuffer);
    }

    public void setScheduleInterval(long scheduleInterval) {
        Assert.isTrue((scheduleInterval > 0L ? 1 : 0) != 0, (String)"Schedule interval must positive!");
        this.scheduleInterval = scheduleInterval;
    }
}

