/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.scan.utils;

import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import top.tangyh.basic.scan.model.SystemApiVO;

public class RequestMappingScanUtils {
    private final Map<String, List<SystemApiVO>> requestMappingMap = new ConcurrentHashMap<String, List<SystemApiVO>>(512);

    private static boolean contains(String[] scanBaseArray, String curPackage) {
        return Arrays.stream(scanBaseArray).anyMatch(sb -> sb.equals(curPackage) || curPackage.startsWith((String)sb));
    }

    private static String getMethods(Set<RequestMethod> requestMethods) {
        StringBuilder sbf = new StringBuilder();
        for (RequestMethod requestMethod : requestMethods) {
            sbf.append(requestMethod.toString()).append(",");
        }
        if (!requestMethods.isEmpty()) {
            sbf.deleteCharAt(sbf.length() - 1);
        } else {
            sbf.append("ALL");
        }
        return sbf.toString();
    }

    private static String getUris(Set<String> urls) {
        StringBuilder sbf = new StringBuilder();
        for (String url : urls) {
            sbf.append(url).append(",");
        }
        if (!urls.isEmpty()) {
            sbf.deleteCharAt(sbf.length() - 1);
        }
        return sbf.toString();
    }

    public void scan(String scanBase, ApplicationContext applicationContext) {
        if (StrUtil.isEmpty((CharSequence)scanBase)) {
            return;
        }
        Environment env = applicationContext.getEnvironment();
        String springApplicationName = env.getProperty("spring.application.name", "base");
        String servicePath = env.getProperty("spring.application.path", "");
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)applicationContext.getBean("requestMappingHandlerMapping");
        String[] scanBaseArray = scanBase.split(",");
        Map map = mapping.getHandlerMethods();
        for (Map.Entry m : map.entrySet()) {
            Operation apiOperation;
            RequestMappingInfo info = (RequestMappingInfo)m.getKey();
            HandlerMethod method = (HandlerMethod)m.getValue();
            String curPackage = method.getMethod().getDeclaringClass().getPackage().getName();
            if (!RequestMappingScanUtils.contains(scanBaseArray, curPackage) || method.getMethodAnnotation(Hidden.class) != null) continue;
            RequestMethodsRequestCondition methodsCondition = info.getMethodsCondition();
            String requestMethod = RequestMappingScanUtils.getMethods(methodsCondition.getMethods());
            PatternsRequestCondition p = info.getPatternsCondition();
            assert (p != null);
            String uri = RequestMappingScanUtils.getUris(p.getPatterns());
            String controller = method.getBeanType().getSimpleName();
            String methodName = method.getMethod().getName();
            Object name = "";
            Tag classApi = method.getBeanType().getAnnotation(Tag.class);
            if (classApi != null) {
                name = classApi.name();
            }
            name = (apiOperation = (Operation)method.getMethodAnnotation(Operation.class)) != null ? (String)name + (StrUtil.isNotEmpty((CharSequence)apiOperation.summary()) ? apiOperation.summary() : apiOperation.description()) : (String)name + methodName;
            SystemApiVO api = SystemApiVO.builder().name((String)name).requestMethod(requestMethod).springApplicationName(springApplicationName).uri(servicePath + uri).controller(controller).build();
            if (this.requestMappingMap.containsKey(controller)) {
                this.requestMappingMap.get(controller).add(api);
                continue;
            }
            ArrayList<SystemApiVO> list = new ArrayList<SystemApiVO>();
            list.add(api);
            this.requestMappingMap.put(controller, list);
        }
    }

    @Generated
    public Map<String, List<SystemApiVO>> getRequestMappingMap() {
        return this.requestMappingMap;
    }
}

