/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.ExcelXorHtmlUtil;
import cn.afterturn.easypoi.excel.entity.ExcelToHtmlParams;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.view.PoiBaseView;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import top.tangyh.basic.annotation.log.SysLog;
import top.tangyh.basic.annotation.security.PreAuth;
import top.tangyh.basic.base.R;
import top.tangyh.basic.base.controller.PageController;
import top.tangyh.basic.base.request.PageParams;
import top.tangyh.basic.utils.BeanPlusUtil;

public interface PoiController<Entity, PageQuery>
extends PageController<Entity, PageQuery> {
    default public Class<?> getExcelClass() {
        return this.getEntityClass();
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @RequestMapping(value={"/export"}, method={RequestMethod.POST}, produces={"application/octet-stream"})
    @SysLog(value="'\u5bfc\u51faExcel:'.concat(#params.extra[fileName]?:'')")
    @PreAuth(value="hasAnyPermission('{}export')")
    default public void exportExcel(@RequestBody @Validated PageParams<PageQuery> params, HttpServletRequest request, HttpServletResponse response) {
        ExportParams exportParams = this.getExportParams(params);
        List<?> list = this.findExportList(params);
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("data", list);
        map.put("entity", this.getExcelClass());
        map.put("params", exportParams);
        Object fileName = params.getExtra().getOrDefault("fileName", "\u4e34\u65f6\u6587\u4ef6");
        map.put("fileName", fileName);
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        PoiBaseView.render(map, (HttpServletRequest)request, (HttpServletResponse)response, (String)"easypoiExcelView");
    }

    default public List<?> findExportList(PageParams<PageQuery> params) {
        params.setSize(params.getSize() == -1L ? Convert.toLong((Object)Integer.MAX_VALUE).longValue() : params.getSize());
        IPage page = this.query(params);
        return BeanPlusUtil.toBeanList((Collection)page.getRecords(), this.getExcelClass());
    }

    @ApiOperation(value="\u9884\u89c8Excel")
    @SysLog(value="'\u9884\u89c8Excel:' + (#params.extra[fileName]?:'')")
    @RequestMapping(value={"/preview"}, method={RequestMethod.POST})
    @PreAuth(value="hasAnyPermission('{}export')")
    default public R<String> preview(@RequestBody @Validated PageParams<PageQuery> params) {
        ExportParams exportParams = this.getExportParams(params);
        List<?> list = this.findExportList(params);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, this.getExcelClass(), list);
        return this.success(ExcelXorHtmlUtil.excelToHtml((ExcelToHtmlParams)new ExcelToHtmlParams(workbook)));
    }

    @ApiOperation(value="\u5bfc\u5165Excel")
    @PostMapping(value={"/import"})
    @SysLog(value="'\u5bfc\u5165Excel:' + #simpleFile?.originalFilename", request=false)
    @PreAuth(value="hasAnyPermission('{}import')")
    default public R<Boolean> importExcel(@RequestParam(value="file") MultipartFile simpleFile, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ImportParams params = new ImportParams();
        params.setTitleRows(StrUtil.isEmpty((CharSequence)request.getParameter("titleRows")) ? 0 : Convert.toInt((Object)request.getParameter("titleRows")));
        params.setHeadRows(StrUtil.isEmpty((CharSequence)request.getParameter("headRows")) ? 1 : Convert.toInt((Object)request.getParameter("headRows")));
        List list = ExcelImportUtil.importExcel((InputStream)simpleFile.getInputStream(), Map.class, (ImportParams)params);
        if (list != null && !list.isEmpty()) {
            return this.handlerImport(list);
        }
        return this.validFail("\u5bfc\u5165Excel\u65e0\u6709\u6548\u6570\u636e\uff01");
    }

    default public R<Boolean> handlerImport(List<Map<String, String>> list) {
        return R.successDef(null, (String)"\u8bf7\u5728\u5b50\u7c7bController\u91cd\u5199\u5bfc\u5165\u65b9\u6cd5\uff0c\u5b9e\u73b0\u5bfc\u5165\u903b\u8f91");
    }

    default public ExportParams getExportParams(PageParams<PageQuery> params) {
        Object title = params.getExtra().get("title");
        Object type = params.getExtra().getOrDefault("type", ExcelType.XSSF.name());
        Object sheetName = params.getExtra().getOrDefault("sheetName", "SheetName");
        ExcelType excelType = ExcelType.XSSF.name().equals(type) ? ExcelType.XSSF : ExcelType.HSSF;
        ExportParams ep = new ExportParams(title == null ? null : String.valueOf(title), sheetName.toString(), excelType);
        this.enhanceExportParams(ep);
        return ep;
    }

    default public void enhanceExportParams(ExportParams ep) {
    }
}

