/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.log.util;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.lionsoul.ip2region.xdb.Searcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddressUtil {
    private static final Logger log = LoggerFactory.getLogger(AddressUtil.class);
    private static Searcher searcher = null;

    private AddressUtil() {
    }

    public static String getRegion(String ip) {
        try {
            if (searcher == null || StrUtil.isEmpty((CharSequence)ip)) {
                log.error("DbSearcher is null");
                return "";
            }
            long startTime = System.currentTimeMillis();
            String result = searcher.search(ip);
            long endTime = System.currentTimeMillis();
            log.debug("region use time[{}] result[{}]", (Object)(endTime - startTime), (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error("\u6839\u636eip\u67e5\u8be2\u5730\u533a\u5931\u8d25:", (Throwable)e);
            return "";
        }
    }

    static {
        try {
            URL resource = AddressUtil.class.getResource("/ip2region/ip2region.xdb");
            if (resource != null) {
                String dbPath = resource.getPath();
                File file = new File(dbPath);
                if (!file.exists()) {
                    String tmpDir = System.getProperties().getProperty("java.io.tmpdir");
                    dbPath = tmpDir + "ip2region.xdb";
                    file = new File(dbPath);
                    String classPath = "classpath:ip2region/ip2region.xdb";
                    InputStream resourceAsStream = ResourceUtil.getStreamSafe((String)classPath);
                    if (resourceAsStream != null) {
                        FileUtils.copyInputStreamToFile((InputStream)resourceAsStream, (File)file);
                    }
                }
                byte[] cBuff = Searcher.loadContentFromFile((String)dbPath);
                searcher = Searcher.newWithBuffer((byte[])cBuff);
                log.info("bean [{}]", (Object)searcher);
            }
        }
        catch (Exception e) {
            log.error("init ip region error", (Throwable)e);
        }
    }
}

