/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.log.event;

import cn.hutool.core.util.StrUtil;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import top.tangyh.basic.context.ContextUtil;
import top.tangyh.basic.log.entity.OptLogDTO;
import top.tangyh.basic.log.event.SysLogEvent;

public class SysLogListener {
    private static final Logger log = LoggerFactory.getLogger(SysLogListener.class);
    private final Consumer<OptLogDTO> consumer;

    @Async
    @Order
    @EventListener(value={SysLogEvent.class})
    public void saveSysLog(SysLogEvent event) {
        OptLogDTO sysLog = (OptLogDTO)event.getSource();
        if (sysLog == null || StrUtil.isEmpty((CharSequence)sysLog.getTenantCode())) {
            log.warn("\u79df\u6237\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u64cd\u4f5c\u65e5\u5fd7=={}", (Object)(sysLog != null ? sysLog.getRequestUri() : ""));
            return;
        }
        ContextUtil.setTenant((String)sysLog.getTenantCode());
        this.consumer.accept(sysLog);
    }

    public SysLogListener(Consumer<OptLogDTO> consumer) {
        this.consumer = consumer;
    }
}

