/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.log.util;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.commons.io.FileUtils;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbSearcher;
import org.lionsoul.ip2region.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddressUtil {
    private static final Logger log = LoggerFactory.getLogger(AddressUtil.class);
    private static DbConfig config = null;
    private static final String JAVA_TEMP_DIR = "java.io.tmpdir";
    private static DbSearcher searcher = null;

    private AddressUtil() {
    }

    public static String getRegion(String ip) {
        try {
            DataBlock dataBlock;
            if (searcher == null || StrUtil.isEmpty((CharSequence)ip)) {
                log.error("DbSearcher is null");
                return "";
            }
            long startTime = System.currentTimeMillis();
            Method method = searcher.getClass().getMethod("memorySearch", String.class);
            if (!Util.isIpAddress((String)ip)) {
                log.warn("warning: Invalid ip address");
            }
            String result = (dataBlock = (DataBlock)method.invoke((Object)searcher, ip)) != null ? dataBlock.getRegion() : "";
            long endTime = System.currentTimeMillis();
            log.debug("region use time[{}] result[{}]", (Object)(endTime - startTime), (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error("\u6839\u636eip\u67e5\u8be2\u5730\u533a\u5931\u8d25:", (Throwable)e);
            return "";
        }
    }

    static {
        try {
            String dbPath = AddressUtil.class.getResource("/ip2region/ip2region.db").getPath();
            File file = new File(dbPath);
            if (!file.exists()) {
                String tmpDir = System.getProperties().getProperty(JAVA_TEMP_DIR);
                dbPath = tmpDir + "ip2region.db";
                file = new File(dbPath);
                String classPath = "classpath:ip2region/ip2region.db";
                InputStream resourceAsStream = ResourceUtil.getStreamSafe((String)classPath);
                if (resourceAsStream != null) {
                    FileUtils.copyInputStreamToFile((InputStream)resourceAsStream, (File)file);
                }
            }
            config = new DbConfig();
            searcher = new DbSearcher(config, dbPath);
            log.info("bean [{}]", (Object)config);
            log.info("bean [{}]", (Object)searcher);
        }
        catch (Exception e) {
            log.error("init ip region error", (Throwable)e);
        }
    }
}

