/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.echo.core;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.annotation.echo.Echo;
import top.tangyh.basic.echo.core.DefCacheLoader;
import top.tangyh.basic.echo.manager.CacheLoadKeys;
import top.tangyh.basic.echo.manager.ClassManager;
import top.tangyh.basic.echo.manager.FieldParam;
import top.tangyh.basic.echo.manager.LoadKey;
import top.tangyh.basic.echo.properties.EchoProperties;
import top.tangyh.basic.jackson.JsonUtil;
import top.tangyh.basic.model.EchoVO;
import top.tangyh.basic.model.LoadService;
import top.tangyh.basic.model.RemoteData;

public class EchoService {
    private static final Logger log = LoggerFactory.getLogger(EchoService.class);
    private static final int DEF_MAP_SIZE = 20;
    private static final String[] BASE_TYPES = new String[]{"java.lang.Integer", "java.lang.Byte", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.Character", "java.lang.Short", "java.lang.Boolean", "java.lang.String", "top.tangyh.basic.model.RemoteData"};
    private static final Map<String, FieldParam> CACHE = new HashMap<String, FieldParam>();
    private final Map<String, LoadService> strategyMap = new ConcurrentHashMap<String, LoadService>();
    private final EchoProperties ips;
    private LoadingCache<CacheLoadKeys, Map<Serializable, Object>> caches;

    public EchoService(EchoProperties ips, Map<String, LoadService> strategyMap) {
        strategyMap.forEach(this.strategyMap::put);
        this.ips = ips;
        EchoProperties.GuavaCache guavaCache = ips.getGuavaCache();
        if (guavaCache.getEnabled().booleanValue()) {
            this.caches = CacheBuilder.newBuilder().maximumSize((long)guavaCache.getMaximumSize().intValue()).refreshAfterWrite((long)guavaCache.getRefreshWriteTime().intValue(), TimeUnit.MINUTES).build((CacheLoader)new DefCacheLoader(guavaCache));
        }
    }

    public void action(Object obj, String ... ignoreFields) {
        this.action(obj, false, ignoreFields);
    }

    public void action(Object obj, boolean isUseCache, String ... ignoreFields) {
        try {
            ConcurrentHashMap<LoadKey, Map<Serializable, Object>> typeMap = new ConcurrentHashMap<LoadKey, Map<Serializable, Object>>(20);
            long parseStart = System.currentTimeMillis();
            this.parse(obj, typeMap, 1, ignoreFields);
            long parseEnd = System.currentTimeMillis();
            if (typeMap.isEmpty()) {
                return;
            }
            this.load(typeMap, isUseCache);
            long echoStart = System.currentTimeMillis();
            this.write(obj, typeMap, 1, new String[0]);
            long echoEnd = System.currentTimeMillis();
            log.info("\u89e3\u6790\u8017\u65f6={} ms", (Object)(parseEnd - parseStart));
            log.info("\u6279\u91cf\u67e5\u8be2\u8017\u65f6={} ms", (Object)(echoStart - parseEnd));
            log.info("\u56de\u663e\u8017\u65f6={} ms", (Object)(echoEnd - echoStart));
        }
        catch (Exception e) {
            log.warn("\u56de\u663e\u5931\u8d25", (Throwable)e);
        }
    }

    private void parse(Object obj, Map<LoadKey, Map<Serializable, Object>> typeMap, int depth, String ... ignoreFields) {
        if (obj == null) {
            return;
        }
        if (depth > this.ips.getMaxDepth()) {
            log.info("\u51fa\u73b0\u5faa\u73af\u4f9d\u8d56\uff0c\u6700\u591a\u6267\u884c {} \u6b21\uff0c \u5df2\u6267\u884c {} \u6b21\uff0c\u5df2\u4e3a\u60a8\u8df3\u51fa\u5faa\u73af", (Object)this.ips.getMaxDepth(), (Object)depth);
            return;
        }
        if (obj instanceof IPage) {
            List records = ((IPage)obj).getRecords();
            this.parseList(records, typeMap, depth, ignoreFields);
            return;
        }
        if (obj instanceof Collection) {
            this.parseList((Collection)obj, typeMap, depth, ignoreFields);
            return;
        }
        List<Field> fields = ClassManager.getFields(obj.getClass());
        for (Field field : fields) {
            FieldParam fieldParam = this.getFieldParam(obj, field, typeMap, innerTypeMap -> this.parse(ReflectUtil.getFieldValue((Object)obj, (Field)field), (Map<LoadKey, Map<Serializable, Object>>)innerTypeMap, depth + 1, ignoreFields), ignoreFields);
            if (fieldParam == null) continue;
            LoadKey type = fieldParam.getLoadKey();
            Map valueMap = typeMap.getOrDefault(type, new ConcurrentHashMap(20));
            valueMap.put(fieldParam.getActualValue(), Collections.emptyMap());
            typeMap.put(type, valueMap);
        }
    }

    private void parseList(Collection<?> list, Map<LoadKey, Map<Serializable, Object>> typeMap, int depth, String ... ignoreFields) {
        for (Object item : list) {
            this.parse(item, typeMap, depth, ignoreFields);
        }
    }

    private void load(Map<LoadKey, Map<Serializable, Object>> typeMap, boolean isUseCache) {
        for (Map.Entry<LoadKey, Map<Serializable, Object>> entries : typeMap.entrySet()) {
            LoadKey type = entries.getKey();
            Map<Serializable, Object> valueMap = entries.getValue();
            Set<Serializable> keys = valueMap.keySet();
            LoadService loadService = this.strategyMap.get(type.getApi());
            if (loadService == null) {
                log.warn("\u5904\u7406\u5b57\u6bb5\u7684\u56de\u663e\u6570\u636e\u65f6\uff0c\u6ca1\u6709\u627e\u5230 @Echo \u4e2d\u7684api\uff1a[{}]\u5b9e\u4f8b\u3002\u8bf7\u786e\u4fdd\u4f60\u81ea\u5b9a\u4e49\u7684\u63a5\u53e3\u5b9e\u73b0\u4e86 LoadService \u4e2d\u7684 findByIds \u65b9\u6cd5\u3002\u82e5api\u6307\u5b9a\u7684\u662fServiceImpl\uff0c\u8bf7\u786e\u4fdd\u5728\u540c\u4e00\u4e2a\u670d\u52a1\u5185\u3002", (Object)type.getApi());
                continue;
            }
            CacheLoadKeys lk = new CacheLoadKeys(type, loadService, keys);
            Map value = this.ips.getGuavaCache().getEnabled() != false && isUseCache ? (Map)this.caches.get((Object)lk) : lk.loadMap();
            typeMap.put(type, value);
        }
    }

    private void write(Object obj, Map<LoadKey, Map<Serializable, Object>> typeMap, int depth, String ... ignoreFields) {
        if (obj == null) {
            return;
        }
        if (depth > this.ips.getMaxDepth()) {
            log.info("\u51fa\u73b0\u5faa\u73af\u4f9d\u8d56\uff0c\u6700\u591a\u6267\u884c {} \u6b21\uff0c \u5df2\u6267\u884c {} \u6b21\uff0c\u5df2\u4e3a\u60a8\u8df3\u51fa\u5faa\u73af", (Object)this.ips.getMaxDepth(), (Object)depth);
            return;
        }
        if (obj instanceof IPage) {
            List records = ((IPage)obj).getRecords();
            this.writeList(records, typeMap, ignoreFields);
            return;
        }
        if (obj instanceof Collection) {
            this.writeList((Collection)obj, typeMap, ignoreFields);
            return;
        }
        this.iterationWrite(obj, typeMap, depth, ignoreFields);
    }

    private void iterationWrite(Object obj, Map<LoadKey, Map<Serializable, Object>> typeMap, int depth, String ... ignoreFields) {
        List<Field> fields = ClassManager.getFields(obj.getClass());
        for (Field field : fields) {
            FieldParam fieldParam = this.getFieldParam(obj, field, typeMap, innerTypeMap -> this.write(ReflectUtil.getFieldValue((Object)obj, (Field)field), (Map<LoadKey, Map<Serializable, Object>>)innerTypeMap, depth + 1, ignoreFields), ignoreFields);
            if (fieldParam == null) continue;
            Echo inField = fieldParam.getEcho();
            Serializable actualValue = fieldParam.getActualValue();
            Object originalValue = fieldParam.getOriginalValue();
            String fieldName = fieldParam.getFieldName();
            String ref = inField.ref();
            LoadKey loadKey = fieldParam.getLoadKey();
            Object echoValue = this.getEchoValue(inField, actualValue, originalValue, loadKey, typeMap);
            if (echoValue == null || echoValue instanceof Map && ((Map)echoValue).isEmpty()) continue;
            if (echoValue instanceof Map && !Object.class.equals((Object)inField.beanClass())) {
                echoValue = JsonUtil.parse((String)JsonUtil.toJson((Object)echoValue), (Class)inField.beanClass());
            }
            if (StrUtil.isNotEmpty((CharSequence)ref)) {
                ReflectUtil.setFieldValue((Object)obj, (String)ref, (Object)echoValue);
            }
            if (obj instanceof EchoVO) {
                EchoVO vo = (EchoVO)obj;
                vo.getEchoMap().put(fieldName, echoValue);
                continue;
            }
            if (originalValue instanceof RemoteData) {
                RemoteData remoteData = (RemoteData)originalValue;
                remoteData.setData(echoValue);
                continue;
            }
            ReflectUtil.setFieldValue((Object)obj, (Field)field, (Object)echoValue);
        }
    }

    private Object getEchoValue(Echo echo, Object actualValue, Object originalValue, LoadKey loadKey, Map<LoadKey, Map<Serializable, Object>> typeMap) {
        if (ObjectUtil.isEmpty((Object)actualValue)) {
            return null;
        }
        Map<Serializable, Object> valueMap = typeMap.get(loadKey);
        if (MapUtil.isEmpty(valueMap)) {
            return null;
        }
        Object newVal = valueMap.get(actualValue);
        if (ObjectUtil.isNotNull((Object)newVal)) {
            return newVal;
        }
        newVal = valueMap.get(actualValue.toString());
        if (ObjectUtil.isNull((Object)newVal) && StrUtil.isNotEmpty((CharSequence)echo.dictType())) {
            List codes = StrUtil.split((CharSequence)originalValue.toString(), (CharSequence)this.ips.getDictItemSeparator());
            newVal = codes.stream().map(item -> {
                String val = valueMap.getOrDefault(echo.dictType() + this.ips.getDictSeparator() + item, "").toString();
                return val == null ? "" : val;
            }).collect(Collectors.joining(this.ips.getDictItemSeparator()));
        }
        return newVal;
    }

    private void writeList(Collection<?> list, Map<LoadKey, Map<Serializable, Object>> typeMap, String ... ignoreFields) {
        for (Object item : list) {
            this.write(item, typeMap, 1, ignoreFields);
        }
    }

    private FieldParam getFieldParam(Object obj, Field field, Map<LoadKey, Map<Serializable, Object>> typeMap, Consumer<Map<LoadKey, Map<Serializable, Object>>> consumer, String ... ignoreFields) {
        FieldParam fieldParam;
        String key = obj.getClass().getName() + "###" + field.getName();
        if (ArrayUtil.contains((Object[])ignoreFields, (Object)field.getName())) {
            log.debug("\u5df2\u7ecf\u5ffd\u7565{}\u5b57\u6bb5\u7684\u89e3\u6790", (Object)field.getName());
            return null;
        }
        if (this.isNotBaseType(field)) {
            consumer.accept(typeMap);
            return null;
        }
        if (CACHE.containsKey(key)) {
            fieldParam = CACHE.get(key);
        } else {
            Echo echo = field.getDeclaredAnnotation(Echo.class);
            LoadKey loadKey = new LoadKey(echo);
            fieldParam = FieldParam.builder().echo(echo).loadKey(loadKey).fieldName(field.getName()).build();
            CACHE.put(key, fieldParam);
        }
        field.setAccessible(true);
        Object originalValue = ReflectUtil.getFieldValue((Object)obj, (Field)field);
        if (originalValue == null) {
            log.debug("\u5b57\u6bb5[{}]\u4e3a\u7a7a,\u8df3\u8fc7", (Object)field.getName());
            return null;
        }
        Serializable actualValue = this.getActualValue(fieldParam.getEcho(), originalValue);
        if (ObjectUtil.isEmpty((Object)actualValue)) {
            return null;
        }
        fieldParam.setOriginalValue(originalValue);
        fieldParam.setActualValue(actualValue);
        return fieldParam;
    }

    private Serializable getActualValue(Echo echo, Object originalValue) {
        Object actualValue;
        if (originalValue instanceof RemoteData) {
            RemoteData remoteData = (RemoteData)originalValue;
            actualValue = (Serializable)remoteData.getKey();
        } else {
            actualValue = (Serializable)originalValue;
        }
        String dictType = echo.dictType();
        if (StrUtil.isNotEmpty((CharSequence)dictType)) {
            actualValue = dictType;
        }
        return actualValue;
    }

    private boolean isNotBaseType(Field field) {
        return !this.isBaseType(field);
    }

    private boolean isBaseType(Field field) {
        String typeName = field.getType().getName();
        for (String baseType : BASE_TYPES) {
            if (!baseType.equals(typeName)) continue;
            return true;
        }
        return false;
    }
}

