/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.utils;

import java.util.regex.Pattern;

public final class ValidatorUtil {
    public static final String REGEX_USERNAME = "^(?!\\d+$)(?![a-zA-Z]+$)\\w{6,255}$";
    public static final Pattern PATTERN_USERNAME = Pattern.compile("^(?!\\d+$)(?![a-zA-Z]+$)\\w{6,255}$");
    public static final String REGEX_PASSWORD = "(?=.*([a-zA-Z].*))(?=.*\\d.*)(?=.*[-*/+.~!@#$%^&()_].*)[a-zA-Z\\d-*/+.~!@#$%^&()_]{6,20}$";
    public static final Pattern PATTERN_PASSWORD = Pattern.compile("(?=.*([a-zA-Z].*))(?=.*\\d.*)(?=.*[-*/+.~!@#$%^&()_].*)[a-zA-Z\\d-*/+.~!@#$%^&()_]{6,20}$");
    public static final String REGEX_EMAIL = "(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])";
    public static final Pattern PATTERN_EMAIL = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])");
    public static final String REGEX_CHINESE = "^[\u4e00-\u9fa5]$";
    public static final Pattern PATTERN_CHINESE = Pattern.compile("^[\u4e00-\u9fa5]$");
    public static final String REGEX_ID_CARD = "(\\d{14}[\\da-zA-Z])|(\\d{17}[\\da-zA-Z])";
    public static final Pattern PATTERN_ID_CARD = Pattern.compile("(\\d{14}[\\da-zA-Z])|(\\d{17}[\\da-zA-Z])");
    public static final String REGEX_URL = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?";
    public static final Pattern PATTERN_URL = Pattern.compile("http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?");
    public static final String REGEX_MOBILE = "(?:0|86|\\+86)?1[3-9]\\d{9}";
    public static final Pattern PATTERN_MOBILE = Pattern.compile("(?:0|86|\\+86)?1[3-9]\\d{9}");
    public static final String REGEX_IP_ADDRESS = "(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})";
    public static final Pattern PATTERN_IP_ADDRESS = Pattern.compile("(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})");

    private ValidatorUtil() {
    }

    public static boolean isUserName(String value) {
        return PATTERN_USERNAME.matcher(value).matches();
    }

    public static boolean isEmail(String value) {
        return PATTERN_EMAIL.matcher(value).matches();
    }

    public static boolean isIdCard(String value) {
        return PATTERN_ID_CARD.matcher(value).matches();
    }

    public static boolean isPassword(String value) {
        return PATTERN_PASSWORD.matcher(value).matches();
    }

    public static boolean isMobile(String value) {
        return PATTERN_MOBILE.matcher(value).matches();
    }

    public static boolean isIpAddress(String value) {
        return PATTERN_IP_ADDRESS.matcher(value).matches();
    }

    public static boolean isUrl(String value) {
        return PATTERN_URL.matcher(value).matches();
    }

    public static boolean isChinese(String value) {
        return PATTERN_CHINESE.matcher(value).matches();
    }
}

