/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import cn.hutool.db.meta.TableType;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbPlusUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbPlusUtil.class);
    private static final Pattern SQL_SERVER_PATTERN = Pattern.compile("jdbc(:p6spy)?:(?<db>\\w+):.*((//)|@)(?<host>.+):(?<port>\\d+)(/|(;databasename=)|:)(?<dbName>\\w+)\\??.*");
    private static final Map<String, DbType> JDBC_DB_TYPE_CACHE = new ConcurrentHashMap<String, DbType>();

    public static String getSqlServerDbName(String url) {
        Matcher m = SQL_SERVER_PATTERN.matcher(url.toLowerCase());
        if (m.find()) {
            return m.group("dbName");
        }
        return null;
    }

    public static String getDataBaseNameByUrl(String jdbcUrl) {
        String database = null;
        if (StrUtil.isBlank((CharSequence)jdbcUrl)) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        if ((jdbcUrl = jdbcUrl.toLowerCase()).startsWith("jdbc:impala")) {
            jdbcUrl = jdbcUrl.replace(":impala", "");
        }
        if (jdbcUrl.startsWith("jdbc:p6spy")) {
            jdbcUrl = jdbcUrl.replace(":p6spy", "");
        }
        int pos1 = jdbcUrl.indexOf(58, 5);
        if (!jdbcUrl.startsWith("jdbc:") || pos1 == -1) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        String name = ReUtil.getGroup1((String)"jdbc:(.*?):", (CharSequence)jdbcUrl);
        if (name.contains("mysql") || name.contains("cobar") || name.contains("taos-rs")) {
            String connUri = jdbcUrl.substring(pos1 + 1);
            if (connUri.startsWith("//")) {
                int pos = connUri.indexOf(47, 2);
                if (pos != -1) {
                    database = connUri.substring(pos + 1);
                }
            } else {
                database = connUri;
            }
            assert (database != null);
            if (database.contains("?")) {
                database = database.substring(0, database.indexOf("?"));
            }
            if (database.contains(";")) {
                database = database.substring(0, database.indexOf(";"));
            }
        } else if (name.contains("dm") || name.contains("sqlserver") || name.contains("microsoft")) {
            database = DbPlusUtil.getSqlServerDbName(jdbcUrl);
        }
        if (StrUtil.isBlank((CharSequence)database)) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        return database;
    }

    public static List<Table> getTables(DataSource ds) {
        Connection conn;
        ArrayList<Table> tables;
        block19: {
            tables = new ArrayList<Table>();
            conn = null;
            try {
                conn = ds.getConnection();
                String catalog = MetaUtil.getCatalog((Connection)conn);
                String schema = MetaUtil.getSchema((Connection)conn);
                DatabaseMetaData metaData = conn.getMetaData();
                try (ResultSet rs = metaData.getTables(catalog, schema, null, Convert.toStrArray((Object)TableType.TABLE));){
                    if (null == rs) break block19;
                    while (rs.next()) {
                        String tableName = rs.getString("TABLE_NAME");
                        if (!StrUtil.isNotBlank((CharSequence)tableName)) continue;
                        Table table = Table.create((String)tableName);
                        table.setCatalog(catalog);
                        table.setSchema(schema);
                        table.setComment(rs.getString("REMARKS"));
                        try (ResultSet rsPk = metaData.getPrimaryKeys(catalog, schema, tableName);){
                            if (null != rsPk) {
                                while (rsPk.next()) {
                                    table.addPk(rsPk.getString("COLUMN_NAME"));
                                }
                            }
                        }
                        tables.add(table);
                    }
                }
            }
            catch (Exception e) {
                try {
                    throw new DbRuntimeException("Get tables error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbUtil.close((Object[])new Object[]{conn});
                    throw throwable;
                }
            }
        }
        DbUtil.close((Object[])new Object[]{conn});
        return tables;
    }

    public static DbType getDbType(DataSource executor) {
        try {
            Connection conn = executor.getConnection();
            return JDBC_DB_TYPE_CACHE.computeIfAbsent(conn.getMetaData().getURL(), JdbcUtils::getDbType);
        }
        catch (SQLException e) {
            throw ExceptionUtils.mpe((Throwable)e);
        }
    }

    public static DbType getDbType(String jdbcUrl) {
        Assert.isFalse((boolean)StringUtils.isBlank((CharSequence)jdbcUrl), (String)"Error: The jdbcUrl is Null, Cannot read database type", (Object[])new Object[0]);
        String url = jdbcUrl.toLowerCase();
        if (url.contains(":mysql:") || url.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (url.contains(":mariadb:")) {
            return DbType.MARIADB;
        }
        if (url.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (url.contains(":sqlserver:") || url.contains(":microsoft:")) {
            return DbType.SQL_SERVER2005;
        }
        if (url.contains(":sqlserver2012:")) {
            return DbType.SQL_SERVER;
        }
        if (url.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (url.contains(":hsqldb:")) {
            return DbType.HSQL;
        }
        if (url.contains(":db2:")) {
            return DbType.DB2;
        }
        if (url.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (url.contains(":h2:")) {
            return DbType.H2;
        }
        if (DbPlusUtil.regexFind(":dm\\d*:", url)) {
            return DbType.DM;
        }
        if (url.contains(":xugu:")) {
            return DbType.XU_GU;
        }
        if (DbPlusUtil.regexFind(":kingbase\\d*:", url)) {
            return DbType.KINGBASE_ES;
        }
        if (url.contains(":phoenix:")) {
            return DbType.PHOENIX;
        }
        if (url.contains(":zenith:")) {
            return DbType.GAUSS;
        }
        if (url.contains(":gbase:")) {
            return DbType.GBASE;
        }
        if (url.contains(":gbasedbt-sqli:") || url.contains(":informix-sqli:")) {
            return DbType.GBASE_8S;
        }
        if (url.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (url.contains(":oscar:")) {
            return DbType.OSCAR;
        }
        if (url.contains(":sybase:")) {
            return DbType.SYBASE;
        }
        if (url.contains(":oceanbase:")) {
            return DbType.OCEAN_BASE;
        }
        if (url.contains(":highgo:")) {
            return DbType.HIGH_GO;
        }
        if (url.contains(":cubrid:")) {
            return DbType.CUBRID;
        }
        if (url.contains(":sap:")) {
            return DbType.SAP_HANA;
        }
        if (url.contains(":impala:")) {
            return DbType.IMPALA;
        }
        if (url.contains(":vertica:")) {
            return DbType.VERTICA;
        }
        if (url.contains(":xcloud:")) {
            return DbType.XCloud;
        }
        if (url.contains(":firebirdsql:")) {
            return DbType.FIREBIRD;
        }
        if (url.contains(":taos-rs:")) {
            return DbType.TDENGINE;
        }
        log.warn("The jdbcUrl is " + jdbcUrl + ", Mybatis Plus Cannot Read Database type or The Database's Not Supported!");
        return DbType.OTHER;
    }

    public static boolean regexFind(String regex, CharSequence input) {
        if (null == input) {
            return false;
        }
        return Pattern.compile(regex).matcher(input).find();
    }
}

