/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.model.cache;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.time.Duration;
import java.util.ArrayList;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import top.tangyh.basic.model.cache.CacheHashKey;
import top.tangyh.basic.model.cache.CacheKey;
import top.tangyh.basic.utils.ArgumentAssert;

@FunctionalInterface
public interface CacheKeyBuilder {
    default public String getPrefix() {
        return null;
    }

    default public String getTenant() {
        return null;
    }

    default public CacheKeyBuilder setTenantId(Long tenantId) {
        return this;
    }

    default public String getModular() {
        return null;
    }

    @NonNull
    public String getTable();

    default public String getField() {
        return null;
    }

    default public ValueType getValueType() {
        return ValueType.obj;
    }

    @Nullable
    default public Duration getExpire() {
        return null;
    }

    default public String getPattern() {
        return StrUtil.format((CharSequence)"*:{}:*", (Object[])new Object[]{this.getTable()});
    }

    default public CacheKey key(Object ... uniques) {
        String key = this.getKey(uniques);
        ArgumentAssert.notEmpty(key, "key \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        return new CacheKey(key, this.getExpire());
    }

    default public CacheHashKey hashFieldKey(@NonNull Object field, Object ... uniques) {
        String key = this.getKey(uniques);
        ArgumentAssert.notEmpty(key, "key \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        ArgumentAssert.notNull(field, "field \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        return new CacheHashKey(key, field, this.getExpire());
    }

    default public CacheHashKey hashKey(Object ... uniques) {
        String key = this.getKey(uniques);
        ArgumentAssert.notEmpty(key, "key \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        return new CacheHashKey(key, null, this.getExpire());
    }

    private String getKey(Object ... uniques) {
        ValueType valueType;
        String modular;
        String tenant;
        ArrayList<String> regionList = new ArrayList<String>();
        String prefix = this.getPrefix();
        if (StrUtil.isNotEmpty((CharSequence)prefix)) {
            regionList.add(prefix);
        }
        if (StrUtil.isNotEmpty((CharSequence)(tenant = this.getTenant()))) {
            regionList.add(tenant);
        }
        if (StrUtil.isNotEmpty((CharSequence)(modular = this.getModular()))) {
            regionList.add(modular);
        }
        String table = this.getTable();
        ArgumentAssert.notEmpty(table, "\u7f13\u5b58\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        regionList.add(table);
        String field = this.getField();
        if (StrUtil.isNotEmpty((CharSequence)field)) {
            regionList.add(field);
        }
        if ((valueType = this.getValueType()) != null) {
            regionList.add(valueType.name());
        }
        for (Object unique : uniques) {
            if (!ObjectUtil.isNotEmpty((Object)unique)) continue;
            regionList.add(String.valueOf(unique));
        }
        return CollUtil.join(regionList, (CharSequence)":");
    }

    public static enum ValueType {
        obj,
        string,
        number;

    }
}

