/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.converter.String2DateConverter;
import top.tangyh.basic.exception.BizException;

public final class DateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String DEFAULT_YEAR_FORMAT = "yyyy";
    public static final String DEFAULT_MONTH_FORMAT = "yyyy-MM";
    public static final String DEFAULT_MONTH_FORMAT_SLASH = "yyyy/MM";
    public static final String DEFAULT_MONTH_FORMAT_EN = "yyyy\u5e74MM\u6708";
    public static final String DEFAULT_WEEK_FORMAT = "yyyy-ww";
    public static final String DEFAULT_WEEK_FORMAT_EN = "yyyy\u5e74ww\u5468";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_DATE_FORMAT_EN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_TIME_START_FORMAT = "yyyy-MM-dd 00:00:00";
    public static final String DEFAULT_DATE_TIME_END_FORMAT = "yyyy-MM-dd 23:59:59";
    public static final String DEFAULT_DATE_TIME_FORMAT_EN = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_TIME_EN_FORMAT = "HH\u65f6mm\u5206ss\u79d2";
    public static final String DAY = "DAY";
    public static final String MONTH = "MONTH";
    public static final String WEEK = "WEEK";
    public static final String DEFAULT_DATE_FORMAT_MATCHES = "^\\d{4}-\\d{1,2}-\\d{1,2}$";
    public static final String DEFAULT_DATE_TIME_FORMAT_MATCHES = "^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$";
    public static final String DEFAULT_MONTH_FORMAT_EN_MATCHES = "^\\d{4}\u5e74\\d{1,2}\u6708$";
    public static final String DEFAULT_DATE_FORMAT_EN_MATCHES = "^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5$";
    public static final String DEFAULT_DATE_TIME_FORMAT_EN_MATCHES = "^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2$";
    public static final String SLASH_DATE_FORMAT_MATCHES = "^\\d{4}/\\d{1,2}/\\d{1,2}$";
    public static final String SLASH_DATE_TIME_FORMAT_MATCHES = "^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$";
    public static final String SLASH_DATE_FORMAT = "yyyy/MM/dd";
    public static final String SLASH_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final String CRON_FORMAT = "ss mm HH dd MM ? yyyy";
    public static final Map<String, String> LOCAL_DATE_TIME_FORMAT_MAP = new LinkedHashMap<String, String>(10);
    public static final Map<String, String> DATE_TIME_FORMAT_MAP = new LinkedHashMap<String, String>(15);
    public static final Map<String, String> LOCAL_DATE_FORMAT_MAP = new LinkedHashMap<String, String>(10);
    public static final Map<String, String> LOCAL_TIME_FORMAT_MAP = new LinkedHashMap<String, String>(10);
    public static final long MAX_MONTH_DAY = 30L;
    public static final long MAX_3_MONTH_DAY = 90L;
    public static final long MAX_YEAR_DAY = 365L;
    private static final Map<String, String> DATE_FORMAT;

    private DateUtils() {
    }

    public static LocalDate parse(String source) {
        String sourceTrim = source.trim();
        Set<Map.Entry<String, String>> entries = DATE_FORMAT.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (!sourceTrim.matches(entry.getValue())) continue;
            return LocalDate.parse(source, DateTimeFormatter.ofPattern(entry.getKey()));
        }
        throw BizException.wrap("\u89e3\u6790\u65e5\u671f\u5931\u8d25, \u8bf7\u4f20\u9012\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f", new Object[0]);
    }

    public static String getCron(Date date) {
        return DateUtils.format(date, CRON_FORMAT);
    }

    public static String getCron(LocalDateTime date) {
        return DateUtils.format(date, CRON_FORMAT);
    }

    public static String format(LocalDateTime date) {
        return DateUtils.format(date, DEFAULT_DATE_TIME_FORMAT);
    }

    public static String format(LocalDateTime date, String pattern) {
        if (date == null) {
            date = LocalDateTime.now();
        }
        if (pattern == null) {
            pattern = DEFAULT_DATE_TIME_FORMAT;
        }
        return date.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(LocalDate date, String pattern) {
        if (date == null) {
            date = LocalDate.now();
        }
        if (pattern == null) {
            pattern = DEFAULT_MONTH_FORMAT;
        }
        return date.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(Date d, String f) {
        Date date = d;
        String format = f;
        if (date == null) {
            date = new Date();
        }
        if (format == null) {
            format = DEFAULT_DATE_TIME_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String formatAsDate(LocalDateTime date) {
        return DateUtils.format(date, DEFAULT_DATE_FORMAT);
    }

    public static String formatAsDate(LocalDate date) {
        return DateUtils.format(date, DEFAULT_DATE_FORMAT);
    }

    public static String formatAsDateEn(LocalDateTime date) {
        return DateUtils.format(date, DEFAULT_DATE_FORMAT_EN);
    }

    public static String formatAsYearMonth(LocalDateTime date) {
        return DateUtils.format(date, DEFAULT_MONTH_FORMAT);
    }

    public static String formatAsYearMonthEn(LocalDateTime date) {
        return DateUtils.format(date, DEFAULT_MONTH_FORMAT_EN);
    }

    public static String formatAsYearWeek(LocalDateTime date) {
        return DateUtils.format(date, DEFAULT_WEEK_FORMAT);
    }

    public static String formatAsYearWeekEn(LocalDateTime date) {
        return DateUtils.format(date, DEFAULT_WEEK_FORMAT_EN);
    }

    public static String formatAsYearMonth(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_MONTH_FORMAT);
        return df.format(date);
    }

    public static String formatAsYearWeek(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_WEEK_FORMAT);
        return df.format(date);
    }

    public static String formatAsTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_TIME_FORMAT);
        return df.format(date);
    }

    public static String formatAsDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        return df.format(date);
    }

    public static String formatAsDateTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_DATE_TIME_FORMAT);
        return df.format(date);
    }

    public static String getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }

    public static String formatAsDay(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("dd");
        return df.format(date);
    }

    public static Date parse(String dateStr, String format) {
        Date date = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setLenient(false);
        try {
            date = dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            log.info("DateUtils error", (Throwable)e);
        }
        return date;
    }

    public static Date getLastDateOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 0);
        return calendar.getTime();
    }

    public static Date parseAsDate(String source) {
        String sourceTrim = source.trim();
        Set<Map.Entry<String, String>> entries = DATE_FORMAT.entrySet();
        try {
            for (Map.Entry<String, String> entry : entries) {
                if (!sourceTrim.matches(entry.getValue())) continue;
                return new SimpleDateFormat(entry.getKey()).parse(source);
            }
        }
        catch (ParseException e) {
            throw BizException.wrap("\u89e3\u6790\u65e5\u671f\u5931\u8d25, \u8bf7\u4f20\u9012\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f", new Object[0]);
        }
        throw BizException.wrap("\u89e3\u6790\u65e5\u671f\u5931\u8d25, \u8bf7\u4f20\u9012\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f", new Object[0]);
    }

    private static <T> T convert(String source, Map<String, String> format, Function<String, T> function) {
        if (source == null || source.isEmpty()) {
            return null;
        }
        String sourceTrim = source.trim();
        Set<Map.Entry<String, String>> entries = format.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (!sourceTrim.matches(entry.getValue())) continue;
            return function.apply(entry.getKey());
        }
        throw new IllegalArgumentException("\u65e0\u6548\u7684\u65e5\u671f\u53c2\u6570\u683c\u5f0f:'" + sourceTrim + "'");
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.parseAsDateTime("2012-12-14 22:22:33"));
        System.out.println(DateUtils.parseAsDateTime("2012-12-14 22:22"));
        System.out.println(DateUtils.parseAsDateTime("2012-12-14 22"));
        System.out.println(DateUtils.parseAsDateTime("2012-01-22"));
        System.out.println(DateUtils.parseAsDateTime("2012-01-22"));
        System.out.println(DateUtils.parseAsDateTime("2012/01/22"));
        System.out.println(new String2DateConverter().convert("2012-12-14 22:22:33"));
        System.out.println(new String2DateConverter().convert("2012-01-22"));
        System.out.println(new String2DateConverter().convert("2012-01-22"));
        System.out.println(new String2DateConverter().convert("2012/01/22"));
    }

    public static Date parseAsDateTime(String dateTime) {
        Function<String, Date> function = format -> {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat((String)format);
                dateFormat.setLenient(false);
                return dateFormat.parse(dateTime);
            }
            catch (ParseException e) {
                log.info("\u8f6c\u6362\u65e5\u671f\u5931\u8d25, date={}, format={}", new Object[]{dateTime, format, e});
                throw new BizException(-9, e.getMessage(), e);
            }
        };
        return DateUtils.convert(dateTime, DATE_TIME_FORMAT_MAP, function);
    }

    public static LocalDate parseAsLocalDate(String source) {
        return DateUtils.convert(source, LOCAL_DATE_FORMAT_MAP, key -> LocalDate.parse(source, DateTimeFormatter.ofPattern(key)));
    }

    public static LocalTime parseAsLocalTime(String source) {
        return DateUtils.convert(source, LOCAL_TIME_FORMAT_MAP, key -> LocalTime.parse(source, DateTimeFormatter.ofPattern(key)));
    }

    public static LocalDateTime parseAsLocalDateTime(String source) {
        Function<String, LocalDateTime> function = key -> {
            if (source.matches(DEFAULT_DATE_FORMAT_MATCHES) || source.matches(DEFAULT_DATE_FORMAT_EN_MATCHES) || source.matches(SLASH_DATE_FORMAT_MATCHES)) {
                return LocalDateTime.of(LocalDate.parse(source, DateTimeFormatter.ofPattern(key)), LocalTime.MIN);
            }
            return LocalDateTime.parse(source, DateTimeFormatter.ofPattern(key));
        };
        return DateUtils.convert(source, LOCAL_DATE_TIME_FORMAT_MAP, function);
    }

    public static Date getDate0000(LocalDateTime value) {
        return DateUtils.getDate0000(value.toLocalDate());
    }

    public static Date getDate0000(Date value) {
        return DateUtils.getDate0000(DateUtils.date2LocalDate(value));
    }

    public static Date getDate0000(LocalDate value) {
        LocalDateTime todayStart = LocalDateTime.of(value, LocalTime.MIN);
        return DateUtils.localDateTime2Date(todayStart);
    }

    public static Date getDate2359(LocalDateTime value) {
        return DateUtils.getDate2359(value.toLocalDate());
    }

    public static Date getDate2359(Date value) {
        return DateUtils.getDate2359(DateUtils.date2LocalDate(value));
    }

    public static Date getDate2359(LocalDate value) {
        LocalDateTime dateEnd = LocalDateTime.of(value, LocalTime.MAX);
        return DateUtils.localDateTime2Date(dateEnd);
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        if (date == null) {
            return LocalDateTime.now();
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static LocalDate date2LocalDate(Date date) {
        if (date == null) {
            return LocalDate.now();
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDate();
    }

    public static LocalTime date2LocalTime(Date date) {
        if (date == null) {
            return LocalTime.now();
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalTime();
    }

    public static LocalDateTime getDateTimeOfTimestamp(long epochMilli) {
        Instant instant = Instant.ofEpochMilli(epochMilli);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime getDateTimeOfSecond(long epochSecond) {
        Instant instant = Instant.ofEpochSecond(epochSecond);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static long until(Date endDate) {
        return LocalDateTime.now().until(DateUtils.date2LocalDateTime(endDate), ChronoUnit.DAYS);
    }

    public static long until(Date startDate, Date endDate) {
        return DateUtils.date2LocalDateTime(startDate).until(DateUtils.date2LocalDateTime(endDate), ChronoUnit.DAYS);
    }

    public static long until(LocalDateTime startDate, LocalDateTime endDate) {
        return startDate.until(endDate, ChronoUnit.DAYS);
    }

    public static long until(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate, ChronoUnit.DAYS);
    }

    public static List<String> getBetweenDay(Date start, Date end) {
        return DateUtils.getBetweenDay(DateUtils.date2LocalDate(start), DateUtils.date2LocalDate(end));
    }

    public static List<String> getBetweenDay(String start, String end) {
        return DateUtils.getBetweenDay(LocalDate.parse(start), LocalDate.parse(end));
    }

    public static List<String> getBetweenDay(LocalDate startDate, LocalDate endDate) {
        return DateUtils.getBetweenDay(startDate, endDate, DEFAULT_DATE_FORMAT);
    }

    public static List<String> getBetweenDayEn(LocalDate startDate, LocalDate endDate) {
        return DateUtils.getBetweenDay(startDate, endDate, DEFAULT_DATE_FORMAT_EN);
    }

    public static List<String> getBetweenDay(LocalDate startDate, LocalDate endDate, String pattern) {
        if (pattern == null) {
            pattern = DEFAULT_DATE_FORMAT;
        }
        ArrayList<String> list = new ArrayList<String>();
        long distance = ChronoUnit.DAYS.between(startDate, endDate);
        if (distance < 1L) {
            return list;
        }
        String finalPattern = pattern;
        Stream.iterate(startDate, d -> d.plusDays(1L)).limit(distance + 1L).forEach(f -> list.add(f.format(DateTimeFormatter.ofPattern(finalPattern))));
        return list;
    }

    public static List<String> getBetweenWeek(Date start, Date end) {
        return DateUtils.getBetweenWeek(DateUtils.date2LocalDate(start), DateUtils.date2LocalDate(end));
    }

    public static List<String> getBetweenWeek(String start, String end) {
        return DateUtils.getBetweenWeek(LocalDate.parse(start), LocalDate.parse(end));
    }

    public static List<String> getBetweenWeek(LocalDate startDate, LocalDate endDate) {
        return DateUtils.getBetweenWeek(startDate, endDate, DEFAULT_WEEK_FORMAT);
    }

    public static List<String> getBetweenWeek(LocalDate startDate, LocalDate endDate, String pattern) {
        ArrayList<String> list = new ArrayList<String>();
        long distance = ChronoUnit.WEEKS.between(startDate, endDate);
        if (distance < 1L) {
            return list;
        }
        Stream.iterate(startDate, d -> d.plusWeeks(1L)).limit(distance + 1L).forEach(f -> list.add(f.format(DateTimeFormatter.ofPattern(pattern))));
        return list;
    }

    public static List<String> getBetweenMonth(Date start, Date end) {
        return DateUtils.getBetweenMonth(DateUtils.date2LocalDate(start), DateUtils.date2LocalDate(end));
    }

    public static List<String> getBetweenMonth(String start, String end) {
        return DateUtils.getBetweenMonth(LocalDate.parse(start), LocalDate.parse(end));
    }

    public static List<String> getBetweenMonth(LocalDate startDate, LocalDate endDate) {
        return DateUtils.getBetweenMonth(startDate, endDate, DEFAULT_MONTH_FORMAT);
    }

    public static List<String> getBetweenMonth(LocalDate startDate, LocalDate endDate, String pattern) {
        ArrayList<String> list = new ArrayList<String>();
        long distance = ChronoUnit.MONTHS.between(startDate, endDate);
        if (distance < 1L) {
            return list;
        }
        Stream.iterate(startDate, d -> d.plusMonths(1L)).limit(distance + 1L).forEach(f -> list.add(f.format(DateTimeFormatter.ofPattern(pattern))));
        return list;
    }

    public static String calculationEn(LocalDateTime startTime, LocalDateTime endTime, List<String> dateList) {
        if (startTime == null) {
            startTime = LocalDateTime.now();
        }
        if (endTime == null) {
            endTime = LocalDateTime.now().plusDays(30L);
        }
        return DateUtils.calculationEn(startTime.toLocalDate(), endTime.toLocalDate(), dateList);
    }

    public static String calculation(LocalDate startDate, LocalDate endDate, List<String> dateList) {
        String dateType;
        long day;
        if (startDate == null) {
            startDate = LocalDate.now();
        }
        if (endDate == null) {
            endDate = LocalDate.now().plusDays(30L);
        }
        if (dateList == null) {
            dateList = new ArrayList<String>();
        }
        if ((day = DateUtils.until(startDate, endDate)) >= 0L && day <= 30L) {
            dateType = DAY;
            dateList.addAll(DateUtils.getBetweenDay(startDate, endDate, DEFAULT_DATE_FORMAT));
        } else if (day > 30L && day <= 90L) {
            dateType = WEEK;
            dateList.addAll(DateUtils.getBetweenWeek(startDate, endDate, DEFAULT_WEEK_FORMAT));
        } else if (day > 90L && day <= 365L) {
            dateType = MONTH;
            dateList.addAll(DateUtils.getBetweenMonth(startDate, endDate, DEFAULT_MONTH_FORMAT));
        } else {
            throw new BizException("\u65e5\u671f\u53c2\u6570\u53ea\u80fd\u4ecb\u4e8e0-365\u5929\u4e4b\u95f4");
        }
        return dateType;
    }

    public static String calculationEn(LocalDate startDate, LocalDate endDate, List<String> dateList) {
        String dateType;
        long day;
        if (startDate == null) {
            startDate = LocalDate.now();
        }
        if (endDate == null) {
            endDate = LocalDate.now().plusDays(30L);
        }
        if (dateList == null) {
            dateList = new ArrayList<String>();
        }
        if ((day = DateUtils.until(startDate, endDate)) >= 0L && day <= 30L) {
            dateType = DAY;
            dateList.addAll(DateUtils.getBetweenDay(startDate, endDate, DEFAULT_DATE_FORMAT_EN));
        } else if (day > 30L && day <= 90L) {
            dateType = WEEK;
            dateList.addAll(DateUtils.getBetweenWeek(startDate, endDate, DEFAULT_WEEK_FORMAT_EN));
        } else if (day > 90L && day <= 365L) {
            dateType = MONTH;
            dateList.addAll(DateUtils.getBetweenMonth(startDate, endDate, DEFAULT_MONTH_FORMAT_EN));
        } else {
            throw new BizException("\u65e5\u671f\u53c2\u6570\u53ea\u80fd\u4ecb\u4e8e0-365\u5929\u4e4b\u95f4");
        }
        return dateType;
    }

    public static LocalDateTime getStartTime(String time) {
        Object startTime = time;
        if (time.matches("^\\d{4}-\\d{1,2}$")) {
            startTime = time + "-01 00:00:00";
        } else if (time.matches(DEFAULT_DATE_FORMAT_MATCHES)) {
            startTime = time + " 00:00:00";
        } else if (time.matches("^\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}$")) {
            startTime = time + ":00";
        } else if (time.matches("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{3}Z$")) {
            startTime = time.replace("T", " ").substring(0, time.indexOf(46));
        }
        return LocalDateTimeUtil.beginOfDay((LocalDateTime)LocalDateTime.parse((CharSequence)startTime, DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMAT)));
    }

    public static LocalDateTime getEndTime(String time) {
        Object startTime = time;
        if (time.matches("^\\d{4}-\\d{1,2}$")) {
            Date date = DateUtils.parse(time, DEFAULT_MONTH_FORMAT);
            date = DateUtils.getLastDateOfMonth(date);
            startTime = DateUtils.formatAsDate(date) + " 23:59:59";
        } else if (time.matches(DEFAULT_DATE_FORMAT_MATCHES)) {
            startTime = time + " 23:59:59";
        } else if (time.matches("^\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}$")) {
            startTime = time + ":59";
        } else if (time.matches("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{3}Z$")) {
            time = time.replace("T", " ").substring(0, time.indexOf(46));
            startTime = time;
        }
        return DateUtils.endOfDay(LocalDateTime.parse((CharSequence)startTime, DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMAT)));
    }

    public static LocalDateTime endOfDay(LocalDateTime time) {
        return time.with(LocalTime.of(23, 59, 59, 999999000));
    }

    public static boolean between(LocalTime from, LocalTime to) {
        if (from == null) {
            throw new IllegalArgumentException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (to == null) {
            throw new IllegalArgumentException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LocalTime now = LocalTime.now();
        return now.isAfter(from) && now.isBefore(to);
    }

    public static LocalDateTime conversionDateTime(LocalDateTime dateTime, String time) {
        if (StrUtil.isEmpty((CharSequence)time)) {
            return LocalDateTime.MAX;
        }
        if (dateTime == null) {
            return DateUtils.endOfDay(LocalDateTime.now());
        }
        if ("0".equals(time)) {
            return DateUtils.endOfDay(dateTime);
        }
        int unit = Character.toLowerCase(time.charAt(time.length() - 1));
        if (time.length() == 1) {
            unit = 100;
        }
        Long lastTime = Convert.toLong((Object)time.substring(0, time.length() - 1));
        return switch (unit) {
            case 115 -> dateTime.plusSeconds(lastTime);
            case 109 -> dateTime.plusMinutes(lastTime);
            case 104 -> dateTime.plusHours(lastTime);
            case 119 -> dateTime.plusWeeks(lastTime);
            case 77 -> dateTime.plusMonths(lastTime);
            case 121 -> dateTime.plusYears(lastTime);
            default -> dateTime.plusDays(lastTime);
        };
    }

    public static Date getServerStartDate() {
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new Date(time);
    }

    public static String tranDurationToShow(Duration duration) {
        long minutes;
        long hours;
        StringBuilder result = new StringBuilder();
        long days = Math.abs(duration.toDays());
        if (days >= 1L) {
            result.append(days).append("\u5929");
        }
        if ((hours = Math.abs(duration.toHours())) >= 1L) {
            if (days >= 1L) {
                long l = hours % 24L;
                if (l > 0L) {
                    result.append(l).append("\u5c0f\u65f6");
                }
                return result.append(duration.toHours() > 0L ? "\u524d" : "\u540e").toString();
            }
            result.append(hours).append("\u5c0f\u65f6");
        }
        if ((minutes = Math.abs(duration.toMinutes())) >= 1L) {
            if (hours >= 1L) {
                long l = minutes % 60L;
                if (l > 0L) {
                    result.append(l).append("\u5206\u949f");
                }
                return result.append(duration.toMinutes() > 0L ? "\u524d" : "\u540e").toString();
            }
            result.append(minutes).append("\u5206\u949f");
        }
        if (result.isEmpty()) {
            result.append("1\u5206\u949f\u5185");
            return result.toString();
        }
        return result.append(duration.toSeconds() > 0L ? "\u524d" : "\u540e").toString();
    }

    static {
        LOCAL_DATE_TIME_FORMAT_MAP.put(DEFAULT_DATE_TIME_FORMAT, DEFAULT_DATE_TIME_FORMAT_MATCHES);
        LOCAL_DATE_TIME_FORMAT_MAP.put(SLASH_DATE_TIME_FORMAT, SLASH_DATE_TIME_FORMAT_MATCHES);
        LOCAL_DATE_TIME_FORMAT_MAP.put(DEFAULT_DATE_TIME_FORMAT_EN, DEFAULT_DATE_TIME_FORMAT_EN_MATCHES);
        LOCAL_DATE_TIME_FORMAT_MAP.put(DEFAULT_DATE_FORMAT, DEFAULT_DATE_FORMAT_MATCHES);
        LOCAL_DATE_TIME_FORMAT_MAP.put(SLASH_DATE_FORMAT, SLASH_DATE_FORMAT_MATCHES);
        LOCAL_DATE_TIME_FORMAT_MAP.put(DEFAULT_DATE_FORMAT_EN, DEFAULT_DATE_FORMAT_EN_MATCHES);
        LOCAL_DATE_FORMAT_MAP.put(DEFAULT_DATE_FORMAT, DEFAULT_DATE_FORMAT_MATCHES);
        LOCAL_DATE_FORMAT_MAP.put(SLASH_DATE_FORMAT, SLASH_DATE_FORMAT_MATCHES);
        LOCAL_DATE_FORMAT_MAP.put(DEFAULT_DATE_FORMAT_EN, DEFAULT_DATE_FORMAT_EN_MATCHES);
        LOCAL_TIME_FORMAT_MAP.put(DEFAULT_TIME_FORMAT, "^\\d{1,2}:\\d{1,2}:\\d{1,2}$");
        LOCAL_TIME_FORMAT_MAP.put(DEFAULT_TIME_EN_FORMAT, "^\\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2$");
        DATE_TIME_FORMAT_MAP.put(DEFAULT_YEAR_FORMAT, "^\\d{4}");
        DATE_TIME_FORMAT_MAP.put(DEFAULT_MONTH_FORMAT, "^\\d{4}-\\d{1,2}$");
        DATE_TIME_FORMAT_MAP.put(DEFAULT_DATE_FORMAT, DEFAULT_DATE_FORMAT_MATCHES);
        DATE_TIME_FORMAT_MAP.put("yyyy-MM-dd HH", "^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}");
        DATE_TIME_FORMAT_MAP.put("yyyy-MM-dd HH:mm", "^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$");
        DATE_TIME_FORMAT_MAP.put(DEFAULT_DATE_TIME_FORMAT, DEFAULT_DATE_TIME_FORMAT_MATCHES);
        DATE_TIME_FORMAT_MAP.put(DEFAULT_MONTH_FORMAT_SLASH, "^\\d{4}/\\d{1,2}$");
        DATE_TIME_FORMAT_MAP.put(SLASH_DATE_FORMAT, SLASH_DATE_FORMAT_MATCHES);
        DATE_TIME_FORMAT_MAP.put("yyyy/MM/dd HH", "^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}");
        DATE_TIME_FORMAT_MAP.put("yyyy/MM/dd HH:mm", "^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}:\\d{1,2}$");
        DATE_TIME_FORMAT_MAP.put(SLASH_DATE_TIME_FORMAT, SLASH_DATE_TIME_FORMAT_MATCHES);
        DATE_TIME_FORMAT_MAP.put(DEFAULT_MONTH_FORMAT_EN, DEFAULT_MONTH_FORMAT_EN_MATCHES);
        DATE_TIME_FORMAT_MAP.put(DEFAULT_DATE_FORMAT_EN, DEFAULT_DATE_FORMAT_EN_MATCHES);
        DATE_TIME_FORMAT_MAP.put(DEFAULT_DATE_TIME_FORMAT_EN, DEFAULT_DATE_TIME_FORMAT_EN_MATCHES);
        DATE_FORMAT = new LinkedHashMap<String, String>(5);
        DATE_FORMAT.put(DEFAULT_DATE_FORMAT, DEFAULT_DATE_FORMAT_MATCHES);
        DATE_FORMAT.put(SLASH_DATE_FORMAT, SLASH_DATE_FORMAT_MATCHES);
        DATE_FORMAT.put(DEFAULT_DATE_FORMAT_EN, DEFAULT_DATE_FORMAT_EN_MATCHES);
    }
}

