/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.function;

import cn.hutool.core.lang.Pair;
import java.util.Optional;
import java.util.function.Function;
import top.tangyh.basic.function.CheckedFunction;

public final class Either<L, R> {
    private final L left;
    private final R right;

    private Either(L left, R right) {
        this.left = left;
        this.right = right;
    }

    private static <L, R> Either<L, R> left(L left) {
        return new Either<L, Object>(left, null);
    }

    private static <L, R> Either<L, R> right(R right) {
        return new Either<Object, R>(null, right);
    }

    public static <T, R> Function<T, Either> lift(CheckedFunction<T, R> function) {
        return t -> {
            try {
                return Either.right(function.apply(t));
            }
            catch (Exception ex) {
                return Either.left(ex);
            }
        };
    }

    public static <T, R> Function<T, Either> liftWithValue(CheckedFunction<T, R> function) {
        return t -> {
            try {
                return Either.right(function.apply(t));
            }
            catch (Exception ex) {
                return Either.left(Pair.of((Object)ex, (Object)t));
            }
        };
    }

    public Optional<L> getLeft() {
        return Optional.ofNullable(this.left);
    }

    public Optional<R> getRight() {
        return Optional.ofNullable(this.right);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public <T> Optional<T> mapLeft(Function<? super L, T> mapper) {
        if (this.isLeft()) {
            return Optional.of(mapper.apply(this.left));
        }
        return Optional.empty();
    }

    public <T> Optional<T> mapRight(Function<? super R, T> mapper) {
        if (this.isRight()) {
            return Optional.of(mapper.apply(this.right));
        }
        return Optional.empty();
    }

    public String toString() {
        if (this.isLeft()) {
            return "Left(" + this.left + ")";
        }
        return "Right(" + this.right + ")";
    }
}

