/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.context;

import cn.hutool.core.convert.Convert;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ContextUtil {
    private static final ThreadLocal<Map<String, String>> THREAD_LOCAL = new TransmittableThreadLocal();

    private ContextUtil() {
    }

    public static void putAll(Map<String, String> map) {
        map.forEach((k, v) -> ContextUtil.set(k, v));
    }

    public static void set(String key, Object value) {
        Map<String, String> map = ContextUtil.getLocalMap();
        map.put(key, value == null ? "" : value.toString());
    }

    public static <T> T get(String key, Class<T> type) {
        Map<String, String> map = ContextUtil.getLocalMap();
        return (T)Convert.convert(type, (Object)map.get(key));
    }

    public static <T> T get(String key, Class<T> type, Object def) {
        Map<String, String> map = ContextUtil.getLocalMap();
        return (T)Convert.convert(type, (Object)map.getOrDefault(key, String.valueOf(def == null ? "" : def)));
    }

    public static String get(String key) {
        Map<String, String> map = ContextUtil.getLocalMap();
        return map.getOrDefault(key, "");
    }

    public static Map<String, String> getLocalMap() {
        Map<String, String> map = THREAD_LOCAL.get();
        if (map == null) {
            map = new ConcurrentHashMap<String, String>(10);
            THREAD_LOCAL.set(map);
        }
        return map;
    }

    public static void setLocalMap(Map<String, String> localMap) {
        THREAD_LOCAL.set(localMap);
    }

    public static Boolean getBoot() {
        return ContextUtil.get("boot", Boolean.class, false);
    }

    public static void setBoot(Boolean val) {
        ContextUtil.set("boot", val);
    }

    public static Long getUserId() {
        return ContextUtil.get("userid", Long.class, 0L);
    }

    public static String getUserIdStr() {
        return String.valueOf(ContextUtil.getUserId());
    }

    public static void setUserId(Long userId) {
        ContextUtil.set("userid", userId);
    }

    public static void setUserId(String userId) {
        ContextUtil.set("userid", userId);
    }

    public static String getAccount() {
        return ContextUtil.get("account", String.class);
    }

    public static void setAccount(String account) {
        ContextUtil.set("account", account);
    }

    public static String getName() {
        return ContextUtil.get("name", String.class);
    }

    public static void setName(String name) {
        ContextUtil.set("name", name);
    }

    public static String getToken() {
        return ContextUtil.get("token", String.class);
    }

    public static void setToken(String token) {
        ContextUtil.set("token", token);
    }

    public static String getTenant() {
        return ContextUtil.get("tenant", String.class, "");
    }

    public static void setTenant(String val) {
        ContextUtil.set("tenant", val);
        ContextUtil.setTenantBasePoolName(val);
        ContextUtil.setTenantExtendPoolName(val);
    }

    public static void clearDatabase() {
        ContextUtil.set("database", "");
    }

    public static String getDatabase() {
        return ContextUtil.get("database", String.class, "");
    }

    public static void setDatabaseBase() {
        ContextUtil.set("database", "lamp_base");
    }

    public static void setDatabaseExtend() {
        ContextUtil.set("database", "lamp_extend");
    }

    public static void setTenantBasePoolName(Object tenant) {
        ContextUtil.set("lamp_base", tenant);
    }

    public static void setTenantExtendPoolName(Object tenant) {
        ContextUtil.set("lamp_extend", tenant);
    }

    public static void setDefTenant() {
        ContextUtil.set("lamp_base", "master");
        ContextUtil.set("lamp_extend", "master");
    }

    public static boolean isDefTenantId() {
        String base = ContextUtil.get("lamp_base");
        if ("master".equals(base)) {
            return true;
        }
        String extend = ContextUtil.get("lamp_extend");
        return "master".equals(extend);
    }

    public static String getSubTenant() {
        return ContextUtil.get("sub_tenant", String.class, "");
    }

    public static void setSubTenant(String val) {
        ContextUtil.set("sub_tenant", val);
    }

    public static String getClientId() {
        return ContextUtil.get("client_id", String.class);
    }

    public static void setClientId(String val) {
        ContextUtil.set("client_id", val);
    }

    public static String getPath() {
        return ContextUtil.get("Path", String.class, "");
    }

    public static void setPath(Object path) {
        ContextUtil.set("Path", path == null ? "" : path);
    }

    public static String getGrayVersion() {
        return ContextUtil.get("gray_version", String.class);
    }

    public static void setGrayVersion(String val) {
        ContextUtil.set("gray_version", val);
    }

    public static boolean isEmptyTenant() {
        return ContextUtil.isEmptyStr("tenant");
    }

    private static boolean isEmptyLong(String key) {
        String val = ContextUtil.getLocalMap().get(key);
        return val == null || "null".equals(val) || "0".equals(val);
    }

    private static boolean isEmptyStr(String key) {
        String val = ContextUtil.getLocalMap().get(key);
        return val == null || "null".equals(val);
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }
}

