/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import cn.hutool.db.meta.TableType;
import com.baomidou.mybatisplus.annotation.DbType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class DbPlusUtil {
    public static String getDataBaseNameByUrl(String jdbcUrl) {
        int pos1;
        String database = null;
        if (StrUtil.isBlank((CharSequence)jdbcUrl)) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        if ((jdbcUrl = jdbcUrl.toLowerCase()).startsWith("jdbc:impala")) {
            jdbcUrl = jdbcUrl.replace(":impala", "");
        }
        if (!jdbcUrl.startsWith("jdbc:") || (pos1 = jdbcUrl.indexOf(58, 5)) == -1) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        String connUri = jdbcUrl.substring(pos1 + 1);
        if (connUri.startsWith("//")) {
            int pos = connUri.indexOf(47, 2);
            if (pos != -1) {
                database = connUri.substring(pos + 1);
            }
        } else {
            database = connUri;
        }
        if (database.contains("?")) {
            database = database.substring(0, database.indexOf("?"));
        }
        if (database.contains(";")) {
            database = database.substring(0, database.indexOf(";"));
        }
        if (StrUtil.isBlank((CharSequence)database)) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        return database;
    }

    public static List<Table> getTables(DataSource ds) {
        Connection conn;
        ArrayList<Table> tables;
        block31: {
            tables = new ArrayList<Table>();
            conn = null;
            try {
                conn = ds.getConnection();
                String catalog = MetaUtil.getCataLog((Connection)conn);
                String schema = MetaUtil.getSchema((Connection)conn);
                DatabaseMetaData metaData = conn.getMetaData();
                try (ResultSet rs = metaData.getTables(catalog, schema, null, Convert.toStrArray((Object)TableType.TABLE));){
                    if (null == rs) break block31;
                    while (rs.next()) {
                        String tableName = rs.getString("TABLE_NAME");
                        if (!StrUtil.isNotBlank((CharSequence)tableName)) continue;
                        Table table = Table.create((String)tableName);
                        table.setCatalog(catalog);
                        table.setSchema(schema);
                        table.setComment(rs.getString("REMARKS"));
                        try (ResultSet rsPk = metaData.getPrimaryKeys(catalog, schema, tableName);){
                            if (null != rsPk) {
                                while (rsPk.next()) {
                                    table.addPk(rsPk.getString("COLUMN_NAME"));
                                }
                            }
                        }
                        tables.add(table);
                    }
                }
            }
            catch (Exception e) {
                try {
                    throw new DbRuntimeException("Get tables error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbUtil.close((Object[])new Object[]{conn});
                    throw throwable;
                }
            }
        }
        DbUtil.close((Object[])new Object[]{conn});
        return tables;
    }

    public static DbType getDbType(String url) {
        if (url.contains(":mysql:") || url.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (url.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (url.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (url.contains(":sqlserver:")) {
            return DbType.SQL_SERVER;
        }
        if (url.contains(":db2:")) {
            return DbType.DB2;
        }
        if (url.contains(":mariadb:")) {
            return DbType.MARIADB;
        }
        if (url.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (url.contains(":h2:")) {
            return DbType.H2;
        }
        if (url.contains(":kingbase:") || url.contains(":kingbase8:")) {
            return DbType.KINGBASE_ES;
        }
        if (url.contains(":dm:")) {
            return DbType.DM;
        }
        if (url.contains(":zenith:")) {
            return DbType.GAUSS;
        }
        if (url.contains(":oscar:")) {
            return DbType.OSCAR;
        }
        if (url.contains(":firebird:")) {
            return DbType.FIREBIRD;
        }
        if (url.contains(":xugu:")) {
            return DbType.XU_GU;
        }
        if (url.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (url.contains(":sybase:")) {
            return DbType.SYBASE;
        }
        return DbType.OTHER;
    }
}

