/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cloud.interceptor;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.tangyh.basic.context.ContextUtil;

public class FeignAddHeaderRequestInterceptor
implements RequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeignAddHeaderRequestInterceptor.class);
    public static final List<String> HEADER_NAME_LIST = Arrays.asList("ApplicationId", "Token", "Authorization", "UserId", "EmployeeId", "Uuid", "Path", "ClientId", "CurrentCompanyId", "CurrentTopCompanyId", "CurrentDeptId", "x-feign", "trace", "gray_version", "stop", "proceed", "trace", "X-Real-IP", "x-forwarded-for");

    public void apply(RequestTemplate template) {
        template.header("x-feign", new String[]{"true"});
        log.info("thread id ={}, name={}", (Object)Thread.currentThread().getId(), (Object)Thread.currentThread().getName());
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            Map localMap = ContextUtil.getLocalMap();
            localMap.forEach((key, value) -> template.header(key, new String[]{URLUtil.encode((String)value)}));
            return;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        if (request == null) {
            log.warn("path={}, \u5728FeignClient API\u63a5\u53e3\u672a\u914d\u7f6eFeignConfiguration\u7c7b\uff0c \u6545\u800c\u65e0\u6cd5\u5728\u8fdc\u7a0b\u8c03\u7528\u65f6\u83b7\u53d6\u8bf7\u6c42\u5934\u4e2d\u7684\u53c2\u6570!", (Object)template.path());
            return;
        }
        HEADER_NAME_LIST.forEach(headerName -> {
            String header = request.getHeader(headerName);
            template.header(headerName, new String[]{ObjectUtil.isEmpty((Object)header) ? URLUtil.encode((String)ContextUtil.get((String)headerName)) : header});
        });
    }
}

