/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cloud.config;

import feign.Feign;
import feign.RequestInterceptor;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;
import top.tangyh.basic.cloud.feign.DateFormatRegister;
import top.tangyh.basic.cloud.interceptor.FeignAddHeaderRequestInterceptor;

@ConditionalOnClass(value={Feign.class})
@AutoConfigureAfter(value={EnableFeignClients.class})
public class OpenFeignAutoConfiguration {
    @Bean
    public DateFormatRegister dateFormatRegister() {
        return new DateFormatRegister();
    }

    @Bean
    public Encoder feignFormEncoder() {
        List converters = new RestTemplate().getMessageConverters();
        ObjectFactory factory = () -> new HttpMessageConverters((Collection)converters);
        return new SpringFormEncoder((Encoder)new SpringEncoder(factory));
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestInterceptor requestInterceptor() {
        return new FeignAddHeaderRequestInterceptor();
    }
}

