/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cloud.config;

import com.alibaba.cloud.sentinel.annotation.SentinelRestTemplate;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Logger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.cloud.openfeign.FeignLoggerFactory;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import top.tangyh.basic.cloud.http.InfoFeignLoggerFactory;
import top.tangyh.basic.cloud.http.RestTemplateHeaderInterceptor;

@ConditionalOnClass(value={OkHttpClient.class})
public class RestTemplateConfiguration {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private final ObjectMapper objectMapper;

    @Bean
    @ConditionalOnMissingBean(value={FeignLoggerFactory.class})
    public FeignLoggerFactory getInfoFeignLoggerFactory() {
        return new InfoFeignLoggerFactory();
    }

    @Bean
    @Profile(value={"dev", "test"})
    Logger.Level devFeignLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    @Profile(value={"docker", "uat", "prod"})
    Logger.Level prodFeignLoggerLevel() {
        return Logger.Level.BASIC;
    }

    @Bean
    @ConditionalOnMissingBean(value={OkHttpClient.class})
    public OkHttpClient okHttp3Client(OkHttpClientFactory httpClientFactory, ConnectionPool connectionPool, FeignHttpClientProperties httpClientProperties) {
        return httpClientFactory.createBuilder(httpClientProperties.isDisableSslValidation()).followRedirects(httpClientProperties.isFollowRedirects()).writeTimeout(Duration.ofSeconds(30L)).readTimeout(Duration.ofSeconds(30L)).connectTimeout(Duration.ofMillis(httpClientProperties.getConnectionTimeout())).connectionPool(connectionPool).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={ConnectionPool.class})
    public ConnectionPool okHttp3ConnectionPool(FeignHttpClientProperties hcp, OkHttpClientConnectionPoolFactory connectionPoolFactory) {
        return connectionPoolFactory.create(hcp.getMaxConnections(), hcp.getTimeToLive(), hcp.getTimeToLiveUnit());
    }

    @Bean
    public RestTemplateHeaderInterceptor requestHeaderInterceptor() {
        return new RestTemplateHeaderInterceptor();
    }

    @Bean(value={"lbRestTemplate"})
    @LoadBalanced
    @SentinelRestTemplate
    @ConditionalOnMissingBean(value={RestTemplate.class})
    public RestTemplate lbRestTemplate(OkHttpClient httpClient, RestTemplateHeaderInterceptor interceptor) {
        RestTemplate lbRestTemplate = new RestTemplate((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(httpClient));
        lbRestTemplate.setInterceptors(Collections.singletonList(interceptor));
        this.configMessageConverters(lbRestTemplate.getMessageConverters());
        return lbRestTemplate;
    }

    @Bean
    @SentinelRestTemplate
    public RestTemplate restTemplate(OkHttpClient httpClient) {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(httpClient));
        this.configMessageConverters(restTemplate.getMessageConverters());
        return restTemplate;
    }

    private void configMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.removeIf(c -> c instanceof StringHttpMessageConverter || c instanceof MappingJackson2HttpMessageConverter);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(UTF_8));
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(this.objectMapper));
    }

    public RestTemplateConfiguration(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

