/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cloud.feign;

import com.alibaba.cloud.sentinel.feign.SentinelContractHolder;
import com.alibaba.cloud.sentinel.feign.SentinelInvocationHandler;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;
import top.tangyh.basic.base.R;

public class LampSentinelInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(LampSentinelInvocationHandler.class);
    public static final String EQUALS = "equals";
    public static final String HASH_CODE = "hashCode";
    public static final String TO_STRING = "toString";
    private final Target<?> target;
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;
    private FallbackFactory fallbackFactory;
    private Map<Method, Method> fallbackMethodMap;

    LampSentinelInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch, FallbackFactory fallbackFactory) {
        this.target = (Target)Util.checkNotNull(target, (String)"target", (Object[])new Object[0]);
        this.dispatch = (Map)Util.checkNotNull(dispatch, (String)"dispatch", (Object[])new Object[0]);
        this.fallbackFactory = fallbackFactory;
        this.fallbackMethodMap = LampSentinelInvocationHandler.toFallbackMethod(dispatch);
    }

    LampSentinelInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        this.target = (Target)Util.checkNotNull(target, (String)"target", (Object[])new Object[0]);
        this.dispatch = (Map)Util.checkNotNull(dispatch, (String)"dispatch", (Object[])new Object[0]);
    }

    static Map<Method, Method> toFallbackMethod(Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        LinkedHashMap<Method, Method> result = new LinkedHashMap<Method, Method>();
        for (Method method : dispatch.keySet()) {
            method.setAccessible(true);
            result.put(method, method);
        }
        return result;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        if (EQUALS.equals(method.getName())) {
            try {
                InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                return this.equals(otherHandler);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if (HASH_CODE.equals(method.getName())) {
            return this.hashCode();
        }
        if (TO_STRING.equals(method.getName())) {
            return this.toString();
        }
        InvocationHandlerFactory.MethodHandler methodHandler = this.dispatch.get(method);
        if (this.target instanceof Target.HardCodedTarget) {
            Target.HardCodedTarget hardCodedTarget = (Target.HardCodedTarget)this.target;
            MethodMetadata methodMetadata = (MethodMetadata)SentinelContractHolder.METADATA_MAP.get(hardCodedTarget.type().getName() + Feign.configKey((Class)hardCodedTarget.type(), (Method)method));
            if (methodMetadata == null) {
                result = methodHandler.invoke(args);
            } else {
                String resourceName = methodMetadata.template().method().toUpperCase() + ":" + hardCodedTarget.url() + methodMetadata.template().path();
                Entry entry = null;
                try {
                    ContextUtil.enter((String)resourceName);
                    entry = SphU.entry((String)resourceName, (EntryType)EntryType.OUT, (int)1, (Object[])args);
                    result = methodHandler.invoke(args);
                }
                catch (Throwable ex) {
                    if (!BlockException.isBlockException((Throwable)ex)) {
                        Tracer.trace((Throwable)ex);
                    }
                    if (this.fallbackFactory != null) {
                        try {
                            Object fallbackResult;
                            Object object = fallbackResult = this.fallbackMethodMap.get(method).invoke(this.fallbackFactory.create(ex), args);
                            return object;
                        }
                        catch (IllegalAccessException e) {
                            throw new AssertionError((Object)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new AssertionError((Object)e.getCause());
                        }
                    }
                    if (R.class == method.getReturnType()) {
                        log.error("feign \u5185\u90e8\u670d\u52a1\u8c03\u7528\u5f02\u5e38", ex);
                        R r = R.fail((String)ex.getLocalizedMessage());
                        return r;
                    }
                    throw ex;
                }
                finally {
                    if (entry != null) {
                        entry.exit(1, args);
                    }
                    ContextUtil.exit();
                }
            }
        } else {
            result = methodHandler.invoke(args);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SentinelInvocationHandler) {
            LampSentinelInvocationHandler other = (LampSentinelInvocationHandler)obj;
            return this.target.equals(other.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }
}

