/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.FeignClientSpecification;
import org.springframework.cloud.openfeign.FeignClientsRegistrar;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import top.tangyh.basic.cloud.config.OpenFeignAutoConfiguration;

public class LampFeignClientsRegistrar
implements ImportBeanDefinitionRegistrar,
BeanClassLoaderAware,
EnvironmentAware {
    private ClassLoader beanClassLoader;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.registerFeignClients(registry);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    private void registerFeignClients(BeanDefinitionRegistry registry) {
        List feignClients = SpringFactoriesLoader.loadFactoryNames(this.getSpringFactoriesLoaderFactoryClass(), (ClassLoader)this.getBeanClassLoader());
        if (feignClients.isEmpty()) {
            return;
        }
        for (String className : feignClients) {
            try {
                Class<?> clazz = this.beanClassLoader.loadClass(className);
                AnnotationAttributes attributes = AnnotatedElementUtils.getMergedAnnotationAttributes(clazz, FeignClient.class);
                if (attributes == null || registry.containsBeanDefinition(className)) continue;
                this.registerClientConfiguration(registry, this.getClientName((Map<String, Object>)attributes), attributes.get((Object)"configuration"));
                this.validate((Map<String, Object>)attributes);
                BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(FeignClientFactoryBean.class);
                definition.addPropertyValue("url", (Object)this.getUrl((Map<String, Object>)attributes));
                definition.addPropertyValue("path", (Object)this.getPath((Map<String, Object>)attributes));
                String name = this.getName((Map<String, Object>)attributes);
                definition.addPropertyValue("name", (Object)name);
                StringBuilder aliasBuilder = new StringBuilder(18);
                if (attributes.containsKey((Object)"contextId")) {
                    String contextId = this.getContextId((Map<String, Object>)attributes);
                    aliasBuilder.append(contextId);
                    definition.addPropertyValue("contextId", (Object)contextId);
                } else {
                    aliasBuilder.append(name);
                }
                definition.addPropertyValue("type", (Object)className);
                definition.addPropertyValue("decode404", attributes.get((Object)"decode404"));
                definition.addPropertyValue("fallback", attributes.get((Object)"fallback"));
                definition.addPropertyValue("fallbackFactory", attributes.get((Object)"fallbackFactory"));
                definition.setAutowireMode(2);
                AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
                String alias = aliasBuilder.append("FeignClient").toString();
                boolean primary = (Boolean)attributes.get((Object)"primary");
                beanDefinition.setPrimary(primary);
                String qualifier = this.getQualifier((Map<String, Object>)attributes);
                if (StringUtils.hasText((String)qualifier)) {
                    alias = qualifier;
                }
                BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, new String[]{alias});
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private Class<?> getSpringFactoriesLoaderFactoryClass() {
        return OpenFeignAutoConfiguration.class;
    }

    private void validate(Map<String, Object> attributes) {
        AnnotationAttributes annotation = AnnotationAttributes.fromMap(attributes);
        FeignClientsRegistrar.validateFallback((Class)annotation.getClass("fallback"));
        FeignClientsRegistrar.validateFallbackFactory((Class)annotation.getClass("fallbackFactory"));
    }

    private String getName(Map<String, Object> attributes) {
        String name = (String)attributes.get("serviceId");
        if (!StringUtils.hasText((String)name)) {
            name = (String)attributes.get("name");
        }
        if (!StringUtils.hasText((String)name)) {
            name = (String)attributes.get("value");
        }
        name = this.resolve(name);
        return FeignClientsRegistrar.getName((String)name);
    }

    private String getContextId(Map<String, Object> attributes) {
        String contextId = (String)attributes.get("contextId");
        if (!StringUtils.hasText((String)contextId)) {
            return this.getName(attributes);
        }
        contextId = this.resolve(contextId);
        return FeignClientsRegistrar.getName((String)contextId);
    }

    private String resolve(String value) {
        if (StringUtils.hasText((String)value)) {
            return this.environment.resolvePlaceholders(value);
        }
        return value;
    }

    private String getUrl(Map<String, Object> attributes) {
        String url = this.resolve((String)attributes.get("url"));
        return FeignClientsRegistrar.getUrl((String)url);
    }

    private String getPath(Map<String, Object> attributes) {
        String path = this.resolve((String)attributes.get("path"));
        return FeignClientsRegistrar.getPath((String)path);
    }

    @Nullable
    private String getQualifier(@Nullable Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String qualifier = (String)client.get("qualifier");
        if (StringUtils.hasText((String)qualifier)) {
            return qualifier;
        }
        return null;
    }

    @Nullable
    private String getClientName(@Nullable Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String value = (String)client.get("contextId");
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("value");
        }
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("name");
        }
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("serviceId");
        }
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        throw new IllegalStateException("\u5fc5\u987b\u5728 @" + FeignClient.class.getSimpleName() + " \u4e2d\u63d0\u4f9b\u201cname\u201d\u6216\u201cvalue\u201d \u5c5e\u6027");
    }

    private void registerClientConfiguration(BeanDefinitionRegistry registry, Object name, Object configuration) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FeignClientSpecification.class);
        builder.addConstructorArgValue(name);
        builder.addConstructorArgValue(configuration);
        registry.registerBeanDefinition(name + "." + FeignClientSpecification.class.getSimpleName(), (BeanDefinition)builder.getBeanDefinition());
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

