/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cache.redis2;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import top.tangyh.basic.cache.redis.NullVal;
import top.tangyh.basic.exception.BizException;
import top.tangyh.basic.model.cache.CacheHashKey;
import top.tangyh.basic.model.cache.CacheKey;
import top.tangyh.basic.utils.ArgumentAssert;

public class CacheResult<T> {
    private String key;
    private Object field;
    private Duration expire;
    private T rawValue;

    public CacheResult(String key) {
        this.key = key;
    }

    public CacheResult(String key, T rawValue) {
        this.key = key;
        this.rawValue = rawValue;
    }

    public CacheResult(String key, Duration expire, T rawValue) {
        this.key = key;
        this.expire = expire;
        this.rawValue = rawValue;
    }

    public CacheResult(CacheKey cacheKey) {
        ArgumentAssert.notNull((Object)cacheKey, (String)"key \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.key = cacheKey.getKey();
        this.expire = cacheKey.getExpire();
    }

    public CacheResult(CacheKey cacheKey, T rawValue) {
        ArgumentAssert.notNull((Object)cacheKey, (String)"key \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.key = cacheKey.getKey();
        this.expire = cacheKey.getExpire();
        this.rawValue = rawValue;
    }

    public CacheResult(CacheHashKey cacheKey, T rawValue) {
        ArgumentAssert.notNull((Object)cacheKey, (String)"key \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.key = cacheKey.getKey();
        this.field = cacheKey.getField();
        this.expire = cacheKey.getExpire();
        this.rawValue = rawValue;
    }

    public T getValue() {
        Map map;
        boolean isEmpty;
        boolean isNil = this.rawValue == null || NullVal.class.equals(this.rawValue.getClass());
        boolean isObj = this.rawValue == null || Object.class.equals(this.rawValue.getClass());
        T t = this.rawValue;
        boolean bl = isEmpty = t instanceof Map && (map = (Map)t).isEmpty();
        if (isNil || isObj || isEmpty) {
            return null;
        }
        return this.rawValue;
    }

    @JsonIgnore
    public boolean isNullVal() {
        Map map;
        T t;
        return this.rawValue != null && (NullVal.class.equals(this.rawValue.getClass()) || (t = this.rawValue) instanceof Map && (map = (Map)t).isEmpty());
    }

    @JsonIgnore
    public boolean isNull() {
        return this.rawValue == null;
    }

    @JsonIgnore
    public <E> List<E> asList() {
        Map map;
        boolean isEmpty;
        boolean isNil = this.rawValue == null || NullVal.class.equals(this.rawValue.getClass());
        boolean isObj = this.rawValue == null || Object.class.equals(this.rawValue.getClass());
        T t = this.rawValue;
        boolean bl = isEmpty = t instanceof Map && (map = (Map)t).isEmpty();
        if (isNil || isObj || isEmpty) {
            return Collections.emptyList();
        }
        return (List)this.rawValue;
    }

    @JsonIgnore
    public String asString() {
        return this.isNullVal() ? null : String.valueOf(this.rawValue);
    }

    @JsonIgnore
    public Long asLong() {
        Map map;
        boolean isEmpty;
        boolean isNil = this.rawValue == null || NullVal.class.equals(this.rawValue.getClass());
        boolean isObj = this.rawValue == null || Object.class.equals(this.rawValue.getClass());
        T t = this.rawValue;
        boolean bl = isEmpty = t instanceof Map && (map = (Map)t).isEmpty();
        if (isNil || isObj || isEmpty) {
            return null;
        }
        T t2 = this.rawValue;
        if (t2 instanceof Long) {
            Long lo = (Long)t2;
            return lo;
        }
        t2 = this.rawValue;
        if (t2 instanceof String) {
            String str = (String)t2;
            return Long.parseLong(str);
        }
        throw BizException.wrap((String)"[{}]\u65e0\u6cd5\u8f6c\u6362\u4e3aLong\u7c7b\u578b", (Object[])new Object[]{this.rawValue});
    }

    @JsonIgnore
    public long asLong(long defValue) {
        try {
            return Long.parseLong(this.asString());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public String toString() {
        return StrUtil.format((CharSequence)"key={}, field={}, isNullVal={}, rawValue={}", (Object[])new Object[]{this.key, this.field, this.isNullVal(), this.getValue()});
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setField(Object field) {
        this.field = field;
    }

    @Generated
    public void setExpire(Duration expire) {
        this.expire = expire;
    }

    @Generated
    public void setRawValue(T rawValue) {
        this.rawValue = rawValue;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Object getField() {
        return this.field;
    }

    @Generated
    public Duration getExpire() {
        return this.expire;
    }

    @Generated
    public T getRawValue() {
        return this.rawValue;
    }
}

