/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import top.tangyh.basic.cache.CaffeineAutoConfigure;
import top.tangyh.basic.cache.RedisAutoConfigure;

@EnableCaching
@Import(value={CaffeineAutoConfigure.class, RedisAutoConfigure.class})
public class CacheAutoConfigure {
    private static final Logger log = LoggerFactory.getLogger(CacheAutoConfigure.class);

    @Bean
    public KeyGenerator keyGenerator() {
        return (target, method, objects) -> {
            StringBuilder sb = new StringBuilder();
            sb.append(target.getClass().getName());
            sb.append(":");
            sb.append(method.getName());
            for (Object obj : objects) {
                if (obj == null) continue;
                sb.append(":");
                sb.append(obj.toString());
            }
            return sb.toString();
        };
    }
}

