/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cache;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import top.tangyh.basic.cache.lock.RedisDistributedLock;
import top.tangyh.basic.cache.properties.CustomCacheProperties;
import top.tangyh.basic.cache.properties.SerializerType;
import top.tangyh.basic.cache.redis.RedisOps;
import top.tangyh.basic.cache.repository.CacheOps;
import top.tangyh.basic.cache.repository.CachePlusOps;
import top.tangyh.basic.cache.repository.impl.RedisOpsImpl;
import top.tangyh.basic.cache.utils.RedisObjectSerializer;
import top.tangyh.basic.lock.DistributedLock;

@ConditionalOnClass(value={RedisConnectionFactory.class})
@ConditionalOnProperty(prefix="lamp.cache", name={"type"}, havingValue="REDIS", matchIfMissing=true)
@EnableConfigurationProperties(value={RedisProperties.class, CustomCacheProperties.class})
public class RedisAutoConfigure {
    private static final Logger log = LoggerFactory.getLogger(RedisAutoConfigure.class);
    private final CustomCacheProperties cacheProperties;

    @Bean
    @ConditionalOnMissingBean
    public DistributedLock redisDistributedLock(@Qualifier(value="redisTemplate") RedisTemplate<String, Object> redisTemplate) {
        return new RedisDistributedLock(redisTemplate);
    }

    @Bean(value={"redisTemplate"})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory factory, RedisSerializer<Object> redisSerializer) {
        RedisTemplate template = new RedisTemplate();
        this.setSerializer(factory, template, redisSerializer);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisSerializer.class})
    public RedisSerializer<Object> redisSerializer() {
        SerializerType serializerType = this.cacheProperties.getSerializerType();
        if (SerializerType.JDK == serializerType) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            return new JdkSerializationRedisSerializer(classLoader);
        }
        return new RedisObjectSerializer();
    }

    private void setSerializer(RedisConnectionFactory factory, RedisTemplate template, RedisSerializer<Object> redisSerializer) {
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringSerializer);
        template.setHashKeySerializer((RedisSerializer)stringSerializer);
        template.setHashValueSerializer(redisSerializer);
        template.setValueSerializer(redisSerializer);
        template.setConnectionFactory(factory);
    }

    @Bean(value={"stringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory factory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(factory);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheOps cacheOps(RedisOps redisOps) {
        log.warn("\u68c0\u67e5\u5230\u7f13\u5b58\u91c7\u7528\u4e86 Redis\u6a21\u5f0f");
        return new RedisOpsImpl(redisOps);
    }

    @Bean
    @ConditionalOnMissingBean
    public CachePlusOps cachePlusOps(RedisOps redisOps) {
        return new RedisOpsImpl(redisOps);
    }

    @Bean(name={"cacheManager"})
    @Primary
    public CacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
        RedisCacheConfiguration defConfig = this.getDefConf();
        defConfig.entryTtl(this.cacheProperties.getDef().getTimeToLive());
        Map<String, CustomCacheProperties.Cache> configs = this.cacheProperties.getConfigs();
        HashMap map = Maps.newHashMap();
        Optional.ofNullable(configs).ifPresent(config -> config.forEach((key, cache) -> {
            RedisCacheConfiguration cfg = this.handleRedisCacheConfiguration((CustomCacheProperties.Cache)cache, defConfig);
            map.put(key, cfg);
        }));
        return RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(defConfig).withInitialCacheConfigurations((Map)map).build();
    }

    private RedisCacheConfiguration getDefConf() {
        RedisCacheConfiguration def = RedisCacheConfiguration.defaultCacheConfig().disableCachingNullValues().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new RedisObjectSerializer()));
        return this.handleRedisCacheConfiguration(this.cacheProperties.getDef(), def);
    }

    private RedisCacheConfiguration handleRedisCacheConfiguration(CustomCacheProperties.Cache redisProperties, RedisCacheConfiguration config) {
        if (Objects.isNull(redisProperties)) {
            return config;
        }
        if (redisProperties.getTimeToLive() != null) {
            config = config.entryTtl(redisProperties.getTimeToLive());
        }
        config = redisProperties.getKeyPrefix() != null ? config.computePrefixWith(cacheName -> redisProperties.getKeyPrefix().concat(":").concat(cacheName).concat(":")) : config.computePrefixWith(cacheName -> cacheName.concat(":"));
        if (!redisProperties.isCacheNullValues()) {
            config = config.disableCachingNullValues();
        }
        if (!redisProperties.isUseKeyPrefix()) {
            config = config.disableKeyPrefix();
        }
        return config;
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisOps getRedisOps(@Qualifier(value="redisTemplate") RedisTemplate<String, Object> redisTemplate, StringRedisTemplate stringRedisTemplate) {
        return new RedisOps(redisTemplate, stringRedisTemplate, this.cacheProperties.getCacheNullVal());
    }

    public RedisAutoConfigure(CustomCacheProperties cacheProperties) {
        this.cacheProperties = cacheProperties;
    }
}

