/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.conn;

import com.github.tobato.fastdfs.domain.conn.Connection;
import com.github.tobato.fastdfs.domain.conn.FdfsConnectionManager;
import com.github.tobato.fastdfs.domain.conn.FdfsConnectionPool;
import com.github.tobato.fastdfs.domain.fdfs.TrackerLocator;
import com.github.tobato.fastdfs.domain.proto.FdfsCommand;
import com.github.tobato.fastdfs.exception.FdfsConnectException;
import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.NotNull;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TrackerConnectionManager
extends FdfsConnectionManager {
    private TrackerLocator trackerLocator;
    @NotNull
    private List<String> trackerList = new ArrayList<String>();

    public TrackerConnectionManager() {
    }

    public TrackerConnectionManager(FdfsConnectionPool pool) {
        super(pool);
    }

    @PostConstruct
    public void initTracker() {
        LOGGER.debug("init trackerLocator {}", this.trackerList);
        this.trackerLocator = new TrackerLocator(this.trackerList);
    }

    public <T> T executeFdfsTrackerCmd(FdfsCommand<T> command) {
        Connection conn = null;
        InetSocketAddress address = null;
        try {
            address = this.trackerLocator.getTrackerAddress();
            LOGGER.debug("\u83b7\u53d6\u5230Tracker\u8fde\u63a5\u5730\u5740{}", (Object)address);
            conn = this.getConnection(address);
            this.trackerLocator.setActive(address);
        }
        catch (FdfsConnectException e) {
            this.trackerLocator.setInActive(address);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unable to borrow buffer from pool", (Throwable)e);
            throw new RuntimeException("Unable to borrow buffer from pool", e);
        }
        return this.execute(address, conn, command);
    }

    public List<String> getTrackerList() {
        return this.trackerList;
    }

    public void setTrackerList(List<String> trackerList) {
        this.trackerList = trackerList;
    }
}

