/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.conn;

import com.github.tobato.fastdfs.domain.conn.Connection;
import com.github.tobato.fastdfs.domain.conn.DefaultConnection;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.springframework.stereotype.Component;

@Component
public class PooledConnectionFactory
extends BaseKeyedPooledObjectFactory<InetSocketAddress, Connection> {
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private int soTimeout;
    private int connectTimeout;
    private Charset charset;
    private String charsetName = "UTF-8";

    public Connection create(InetSocketAddress address) throws Exception {
        if (null == this.charset) {
            this.charset = Charset.forName(this.charsetName);
        }
        return new DefaultConnection(address, this.soTimeout, this.connectTimeout, this.charset);
    }

    public PooledObject<Connection> wrap(Connection conn) {
        return new DefaultPooledObject((Object)conn);
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void destroyObject(InetSocketAddress key, PooledObject<Connection> p) throws Exception {
        ((Connection)p.getObject()).close();
    }

    public boolean validateObject(InetSocketAddress key, PooledObject<Connection> p) {
        return ((Connection)p.getObject()).isValid();
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }
}

