/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.conn;

import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="fdfs.pool")
public class ConnectionPoolConfig
extends GenericKeyedObjectPoolConfig {
    public static final int FDFS_MAX_TOTAL = -1;
    public static final int FDFS_MAX_TOTAL_PER_KEY = 50;
    public static final int FDFS_MAX_IDLE_PER_KEY = 10;
    public static final int FDFS_MIN_IDLE_PER_KEY = 5;
    public static final boolean FDFS_TEST_WHILE_IDLE = false;
    public static final boolean FDFS_BLOCK_WHEN_EXHAUSTED = true;
    public static final long FDFS_MAX_WAIT_MILLIS = 5000L;
    public static final long FDFS_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    public static final long FDFS_TIME_BETWEEN_EVICTION_RUNS_MILLIS = 60000L;
    public static final int FDFS_NUM_TESTS_PEREVICTION_RUN = 3;
    public static final String FDFS_JMX_NAME_BASE = "com.github.tobato.fastdfs.conn:type=FdfsConnectionPool";
    public static final String FDFS_JMX_NAME_PREFIX = "fdfsPool";
    public static final int FDFS_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS = -1;
    public static final boolean FDFS_TEST_ON_CREATE = false;
    public static final boolean FDFS_TEST_ON_BORROW = true;

    public ConnectionPoolConfig() {
        this.setMaxTotal(-1);
        this.setTestWhileIdle(false);
        this.setBlockWhenExhausted(true);
        this.setMaxWaitMillis(5000L);
        this.setMaxTotalPerKey(50);
        this.setMaxIdlePerKey(10);
        this.setMinIdlePerKey(5);
        this.setMinEvictableIdleTimeMillis(1800000L);
        this.setTimeBetweenEvictionRunsMillis(60000L);
        this.setNumTestsPerEvictionRun(3);
        this.setJmxNameBase(FDFS_JMX_NAME_BASE);
        this.setJmxNamePrefix(FDFS_JMX_NAME_PREFIX);
        this.setSoftMinEvictableIdleTimeMillis(-1L);
        this.setTestOnCreate(false);
        this.setTestOnBorrow(true);
    }
}

