/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.conn;

import com.github.tobato.fastdfs.domain.conn.Connection;
import com.github.tobato.fastdfs.domain.conn.FdfsConnectionPool;
import com.github.tobato.fastdfs.domain.proto.FdfsCommand;
import com.github.tobato.fastdfs.exception.FdfsException;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FdfsConnectionManager {
    @Autowired
    private FdfsConnectionPool pool;
    protected static final Logger LOGGER = LoggerFactory.getLogger(FdfsConnectionManager.class);

    public FdfsConnectionManager() {
    }

    public FdfsConnectionManager(FdfsConnectionPool pool) {
        this.pool = pool;
    }

    public <T> T executeFdfsCmd(InetSocketAddress address, FdfsCommand<T> command) {
        Connection conn = this.getConnection(address);
        return this.execute(address, conn, command);
    }

    protected <T> T execute(InetSocketAddress address, Connection conn, FdfsCommand<T> command) {
        boolean isException = false;
        try {
            LOGGER.debug("\u5bf9\u5730\u5740{}\u53d1\u51fa\u4ea4\u6613\u8bf7\u6c42{}", (Object)address, (Object)command.getClass().getSimpleName());
            T t = command.execute(conn);
            return t;
        }
        catch (FdfsException e) {
            LOGGER.error("execute fdfs command error", (Throwable)e);
            isException = true;
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("execute fdfs command exception", (Throwable)e);
            isException = true;
            throw new RuntimeException("execute fdfs command error", e);
        }
        finally {
            if (isException) {
                LOGGER.debug("remove connect {}", (Object)conn);
                this.removeConnect(address, conn);
            } else {
                LOGGER.debug("return connect {}", (Object)conn);
                this.returnConnect(address, conn);
            }
        }
    }

    private void removeConnect(InetSocketAddress address, Connection conn) {
        try {
            if (null != conn) {
                this.pool.invalidateObject(address, conn);
            }
        }
        catch (Exception e) {
            LOGGER.error("remove pooled connection error", (Throwable)e);
        }
    }

    private void returnConnect(InetSocketAddress address, Connection conn) {
        try {
            if (null != conn) {
                this.pool.returnObject(address, conn);
            }
        }
        catch (Exception e) {
            LOGGER.error("return pooled connection error", (Throwable)e);
        }
    }

    protected Connection getConnection(InetSocketAddress address) {
        Connection conn = null;
        try {
            conn = (Connection)this.pool.borrowObject(address);
        }
        catch (FdfsException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unable to borrow buffer from pool", (Throwable)e);
            throw new RuntimeException("Unable to borrow buffer from pool", e);
        }
        return conn;
    }

    public FdfsConnectionPool getPool() {
        return this.pool;
    }

    public void setPool(FdfsConnectionPool pool) {
        this.pool = pool;
    }

    public void dumpPoolInfo(InetSocketAddress address) {
        LOGGER.debug("==============Begin Dump Pool Info==========");
        LOGGER.debug("Address={}", (Object)address);
        LOGGER.debug("\u8fde\u63a5\u6c60\u6700\u5927\u8fde\u63a5\u6570\u914d\u7f6e{}", (Object)this.pool.getMaxTotal());
        LOGGER.debug("\u6bcf\u4e2aKey\u6700\u5927\u8fde\u63a5\u6570\u914d\u7f6e{}", (Object)this.pool.getMaxTotalPerKey());
        LOGGER.debug("\u6bcf\u4e2akey\u5bf9\u5e94\u8fde\u63a5\u6c60\u6700\u5927\u7a7a\u95f2\u8fde\u63a5\u6570{}", (Object)this.pool.getMaxIdlePerKey());
        LOGGER.debug("\u6bcf\u4e2akey\u5bf9\u5e94\u8fde\u63a5\u6c60\u6700\u5c0f\u7a7a\u95f2\u8fde\u63a5\u6570{}", (Object)this.pool.getMinIdlePerKey());
        LOGGER.debug("\u6d3b\u52a8\u8fde\u63a5{}", (Object)this.pool.getNumActive(address));
        LOGGER.debug("\u7a7a\u95f2\u8fde\u63a5{}", (Object)this.pool.getNumIdle(address));
        LOGGER.debug("\u83b7\u53d6\u524d\u6d4b\u8bd5\u8fde\u63a5\u72b6\u6001{}", (Object)this.pool.getTestOnBorrow());
        LOGGER.debug("\u5f52\u8fd8\u524d\u6d4b\u8bd5\u8fde\u63a5\u72b6\u6001{}", (Object)this.pool.getTestOnReturn());
        LOGGER.debug("\u7a7a\u95f2\u65f6\u6d4b\u8bd5\u8fde\u63a5\u72b6\u6001{}", (Object)this.pool.getTestWhileIdle());
        LOGGER.debug("\u8fde\u63a5\u83b7\u53d6\u603b\u6570\u7edf\u8ba1{}", (Object)this.pool.getBorrowedCount());
        LOGGER.debug("\u8fde\u63a5\u8fd4\u56de\u603b\u6570\u7edf\u8ba1{}", (Object)this.pool.getReturnedCount());
        LOGGER.debug("\u8fde\u63a5\u9500\u6bc1\u603b\u6570\u7edf\u8ba1{}", (Object)this.pool.getDestroyedCount());
        LOGGER.debug("JmxName={}", (Object)this.pool.getJmxName());
        LOGGER.debug("==============END Dump Pool ================");
    }

    public void dumpFullPoolInfo() {
    }
}

