/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.upload;

import com.github.tobato.fastdfs.domain.fdfs.MetaData;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public abstract class AbstractFastFileBuilder<T> {
    protected InputStream inputStream;
    protected long fileSize;
    protected String fileExtName;
    protected Set<MetaData> metaDataSet = new HashSet<MetaData>();
    protected String groupName;

    public AbstractFastFileBuilder<T> withFile(InputStream inputStream, long fileSize, String fileExtName) {
        this.inputStream = inputStream;
        this.fileSize = fileSize;
        this.fileExtName = fileExtName;
        return this;
    }

    public AbstractFastFileBuilder<T> withMetaData(String name, String value) {
        this.metaDataSet.add(new MetaData(name, value));
        return this;
    }

    public AbstractFastFileBuilder<T> withMetaData(Set<MetaData> metaDataSet) {
        Validate.notNull(metaDataSet, (String)"\u5143\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.metaDataSet.addAll(metaDataSet);
        return this;
    }

    public AbstractFastFileBuilder<T> toGroup(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public abstract T build();
}

