/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.fdfs;

import com.github.tobato.fastdfs.domain.fdfs.CircularList;
import com.github.tobato.fastdfs.domain.fdfs.TrackerAddressHolder;
import com.github.tobato.fastdfs.exception.FdfsUnavailableException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TrackerLocator {
    private static final int DEFAULT_RETRY_AFTER_SECOND = 600;
    private List<String> trackerList = new ArrayList<String>();
    private Map<InetSocketAddress, TrackerAddressHolder> trackerAddressMap = new HashMap<InetSocketAddress, TrackerAddressHolder>();
    private CircularList<TrackerAddressHolder> trackerAddressCircular = new CircularList();
    private int retryAfterSecond = 600;

    public TrackerLocator(List<String> trackerList) {
        this.trackerList = trackerList;
        this.buildTrackerAddresses();
    }

    private void buildTrackerAddresses() {
        HashSet<InetSocketAddress> addressSet = new HashSet<InetSocketAddress>();
        for (String string : this.trackerList) {
            if (StringUtils.isBlank((CharSequence)string)) continue;
            String[] parts = StringUtils.split((String)string, (String)":", (int)2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("the value of item \"tracker_server\" is invalid, the correct format is host:port");
            }
            InetSocketAddress address = new InetSocketAddress(parts[0].trim(), Integer.parseInt(parts[1].trim()));
            addressSet.add(address);
        }
        for (InetSocketAddress inetSocketAddress : addressSet) {
            TrackerAddressHolder holder = new TrackerAddressHolder(inetSocketAddress);
            this.trackerAddressCircular.add(holder);
            this.trackerAddressMap.put(inetSocketAddress, holder);
        }
    }

    public void setTrackerList(List<String> trackerList) {
        this.trackerList = trackerList;
    }

    public void setRetryAfterSecond(int retryAfterSecond) {
        this.retryAfterSecond = retryAfterSecond;
    }

    public InetSocketAddress getTrackerAddress() {
        for (int i = 0; i < this.trackerAddressCircular.size(); ++i) {
            TrackerAddressHolder holder = this.trackerAddressCircular.next();
            if (!holder.canTryToConnect(this.retryAfterSecond)) continue;
            return holder.getAddress();
        }
        throw new FdfsUnavailableException("\u627e\u4e0d\u5230\u53ef\u7528\u7684tracker " + this.getTrackerAddressConfigString());
    }

    private String getTrackerAddressConfigString() {
        StringBuffer config = new StringBuffer();
        for (int i = 0; i < this.trackerAddressCircular.size(); ++i) {
            TrackerAddressHolder holder = this.trackerAddressCircular.next();
            InetSocketAddress address = holder.getAddress();
            config.append(address.toString()).append(",");
        }
        return new String(config);
    }

    public void setActive(InetSocketAddress address) {
        TrackerAddressHolder holder = this.trackerAddressMap.get(address);
        holder.setActive();
    }

    public void setInActive(InetSocketAddress address) {
        TrackerAddressHolder holder = this.trackerAddressMap.get(address);
        holder.setInActive();
    }

    public List<String> getTrackerList() {
        return Collections.unmodifiableList(this.trackerList);
    }
}

