/*
 * Decompiled with CFR 0.152.
 */
package top.mdoufei.logkit.logcat;

import android.support.annotation.NonNull;
import top.mdoufei.logkit.Formatter;
import top.mdoufei.logkit.LogKit;
import top.mdoufei.logkit.LogManager;
import top.mdoufei.logkit.Util;
import top.mdoufei.logkit.logcat.LogCatAppender;

public class LogCatFormatter
implements Formatter {
    private static final char TOP_LEFT_CORNER = '\u250c';
    private static final char BOTTOM_LEFT_CORNER = '\u2514';
    private static final char MIDDLE_CORNER = '\u251c';
    private static final char HORIZONTAL_LINE = '\u2502';
    private static final String DOUBLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String SINGLE_DIVIDER = "\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final String TOP_BORDER = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String BOTTOM_BORDER = "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String MIDDLE_BORDER = "\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final int CHUNK_SIZE = 4000;
    private static final int MIN_STACK_OFFSET = 5;
    LogCatAppender logCatAppender = new LogCatAppender();

    @Override
    public void log(int priority, String tag, @NonNull String message) {
        this.logChunk(priority, tag, TOP_BORDER);
        this.logChunk(priority, tag, "\u2502 Thread: " + Thread.currentThread().getName());
        this.logChunk(priority, tag, MIDDLE_BORDER);
        this.logHeaderContent(priority, tag, 1);
        this.logChunk(priority, tag, MIDDLE_BORDER);
        byte[] bytes = message.getBytes();
        int length = bytes.length;
        if (length <= 4000) {
            this.logContent(priority, tag, message);
            this.logChunk(priority, tag, BOTTOM_BORDER);
            return;
        }
        this.logContent(priority, tag, "Content oversize... Over 4000 bytes.");
        this.logChunk(priority, tag, BOTTOM_BORDER);
    }

    private void logChunk(int priority, String tag, @NonNull String message) {
        this.logCatAppender.log(priority, tag, message);
    }

    private void logContent(int priority, String tag, @NonNull String message) {
        String[] lines;
        for (String line : lines = message.split(System.getProperty("line.separator"))) {
            this.logChunk(priority, tag, "\u2502 " + line);
        }
    }

    private int getStackOffset(@NonNull StackTraceElement[] trace) {
        for (int i = 5; i < trace.length; ++i) {
            StackTraceElement e = trace[i];
            String name = e.getClassName();
            if (name.equals(LogManager.class.getName()) || name.equals(LogKit.class.getName())) continue;
            return --i;
        }
        return -1;
    }

    private void logHeaderContent(int priority, String tag, int methodCount) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        String level = "";
        int stackOffset = this.getStackOffset(trace) + 0;
        if (methodCount + stackOffset > trace.length) {
            methodCount = trace.length - stackOffset - 1;
        }
        for (int i = methodCount; i > 0; --i) {
            int stackIndex = i + stackOffset;
            if (stackIndex >= trace.length) continue;
            StringBuilder builder = new StringBuilder();
            builder.append('\u2502').append(' ').append(level).append(Util.getSimpleClassName(trace[stackIndex].getClassName())).append(".").append(trace[stackIndex].getMethodName()).append(" ").append(" (").append(trace[stackIndex].getFileName()).append(":").append(trace[stackIndex].getLineNumber()).append(")");
            level = level + "   ";
            this.logChunk(priority, tag, builder.toString());
        }
    }
}

