/*
 * Decompiled with CFR 0.152.
 */
package top.lrshuai.encryption;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public class RsaUtils {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_MD5_ALGORITHM = "MD5withRSA";
    public static final String SIGNATURE_SHA1_ALGORITHM = "SHA1withRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final String CHARSET_NAME = "UTF-8";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final int INITIALIZE_LENGTH = 1024;

    public static Map<String, String> genKeyPair() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, String> keyMap = new HashMap<String, String>(2);
        keyMap.put(PUBLIC_KEY, Base64.encodeBase64String((byte[])publicKey.getEncoded()));
        keyMap.put(PRIVATE_KEY, Base64.encodeBase64String((byte[])privateKey.getEncoded()));
        return keyMap;
    }

    public static String sign(String signAlgorithm, String privateKey, byte[] data) throws Exception {
        PrivateKey privateK = RsaUtils.getPrivateKey(privateKey);
        Signature signature = Signature.getInstance(signAlgorithm);
        signature.initSign(privateK);
        signature.update(data);
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public static boolean verify(String signAlgorithm, String publicKey, byte[] data, String sign) throws Exception {
        PublicKey publicK = RsaUtils.getPublicKey(publicKey);
        Signature signature = Signature.getInstance(signAlgorithm);
        signature.initVerify(publicK);
        signature.update(data);
        return signature.verify(Base64.decodeBase64((String)sign));
    }

    public static byte[] decryptByPrivateKey(String privateKey, byte[] encryptedData) throws Exception {
        Cipher cipher = RsaUtils.getCipher(2, RsaUtils.getPrivateKey(privateKey));
        return RsaUtils.segmentBytes(cipher, encryptedData, 128);
    }

    public static byte[] decryptByPublicKey(String publicKey, byte[] encryptedData) throws Exception {
        Cipher cipher = RsaUtils.getCipher(2, RsaUtils.getPublicKey(publicKey));
        return RsaUtils.segmentBytes(cipher, encryptedData, 128);
    }

    public static byte[] encryptByPublicKey(String publicKey, byte[] data) throws Exception {
        Cipher cipher = RsaUtils.getCipher(1, RsaUtils.getPublicKey(publicKey));
        return RsaUtils.segmentBytes(cipher, data, 117);
    }

    public static byte[] encryptByPrivateKey(String privateKey, byte[] data) throws Exception {
        Cipher cipher = RsaUtils.getCipher(1, RsaUtils.getPrivateKey(privateKey));
        return RsaUtils.segmentBytes(cipher, data, 117);
    }

    private static byte[] segmentBytes(Cipher cipher, byte[] data, int maxBlock) {
        byte[] result = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int len = data.length;
            int offSet = 0;
            int i = 0;
            while (len - offSet > 0) {
                byte[] cache = len - offSet > maxBlock ? cipher.doFinal(data, offSet, maxBlock) : cipher.doFinal(data, offSet, len - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * maxBlock;
            }
            result = out.toByteArray();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static Cipher getCipher(int mode, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(mode, key);
        return cipher;
    }

    public static PrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public static PublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey));
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generatePublic(x509KeySpec);
    }

    public static String encodeBase64PublicKey(String publicKey, String data) throws Exception {
        return Base64.encodeBase64String((byte[])RsaUtils.encryptByPublicKey(publicKey, data.getBytes()));
    }

    public static String encodeBase64PrivateKey(String privateKey, String data) throws Exception {
        return Base64.encodeBase64String((byte[])RsaUtils.encryptByPrivateKey(privateKey, data.getBytes()));
    }

    public static String decodeBase64ByPrivate(String privateKey, String data) throws Exception {
        return new String(RsaUtils.decryptByPrivateKey(privateKey, Base64.decodeBase64((String)data)), CHARSET_NAME);
    }

    public static String decodeBase64ByPublicKey(String publicKey, String data) throws Exception {
        return new String(RsaUtils.decryptByPublicKey(publicKey, Base64.decodeBase64((String)data)), CHARSET_NAME);
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> keyMap = RsaUtils.genKeyPair();
        String myPublicKey = keyMap.get(PUBLIC_KEY);
        String myPrivateKey = keyMap.get(PRIVATE_KEY);
        String text = "\u6211\u662f\u9700\u8981\u52a0\u5bc6\u7684\u6587\u672cabc";
        String encodePublicKey = RsaUtils.encodeBase64PublicKey(myPublicKey, text);
        String encodePrivateKey = RsaUtils.encodeBase64PrivateKey(myPrivateKey, text);
        System.out.println("\u516c\u94a5\u52a0\u5bc6=" + encodePublicKey);
        System.out.println("\u79c1\u94a5\u52a0\u5bc6=" + encodePrivateKey);
        String decodeByPublicKey = RsaUtils.decodeBase64ByPublicKey(myPublicKey, encodePrivateKey);
        String decodeByPrivate = RsaUtils.decodeBase64ByPrivate(myPrivateKey, encodePublicKey);
        System.out.println();
        System.out.println("\u79c1\u94a5\u89e3\u5bc6=" + decodeByPrivate);
        System.out.println("\u516c\u94a5\u89e3\u5bc6=" + decodeByPublicKey);
        String sign = RsaUtils.sign(SIGNATURE_SHA1_ALGORITHM, myPrivateKey, text.getBytes());
        System.out.println("sign=" + sign);
        boolean verify = RsaUtils.verify(SIGNATURE_SHA1_ALGORITHM, myPublicKey, text.getBytes(), sign);
        System.out.println("is verify=" + verify);
    }
}

