/*
 * Decompiled with CFR 0.152.
 */
package top.lrshuai.encryption;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AesUtils {
    private static final String AES = "AES";
    private static final String AES_PKCS5P = "AES/ECB/PKCS5Padding";
    private static final String CHARSET_NAME = "UTF-8";
    private static final int KEY_SIZE_128 = 128;
    private static final int KEY_SIZE_192 = 192;
    private static final int KEY_SIZE_256 = 256;

    public static String generateSecret(int keySize) {
        String result = UUID.randomUUID().toString().replaceAll("-", "");
        if (128 == keySize) {
            result = result.substring(0, 16);
        } else if (192 == keySize) {
            result = result.substring(0, 24);
        } else if (256 == keySize) {
            result = result.substring(0, 32);
        } else {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff0c\u957f\u5ea6\u53ef\u9009\uff1a128\u3001192\u3001256");
        }
        return result;
    }

    public static byte[] encrypt(String content, String pwdKey) throws GeneralSecurityException, UnsupportedEncodingException {
        Cipher cipher = AesUtils.getCipher(1, pwdKey);
        return cipher.doFinal(content.getBytes(CHARSET_NAME));
    }

    public static String encodeBase64(String content, String pwdKey) throws GeneralSecurityException, UnsupportedEncodingException {
        return Base64.encodeBase64String((byte[])AesUtils.encrypt(content, pwdKey));
    }

    public static byte[] decrypt(byte[] content, String pwdKey) throws GeneralSecurityException, UnsupportedEncodingException {
        Cipher cipher = AesUtils.getCipher(2, pwdKey);
        return cipher.doFinal(content);
    }

    public static String decodeBase64(String content, String pwdKey) throws GeneralSecurityException, UnsupportedEncodingException {
        return new String(AesUtils.decrypt(Base64.decodeBase64((String)content), pwdKey), CHARSET_NAME);
    }

    private static Cipher getCipher(int cipherMode, String pwdKey) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] raw = pwdKey.getBytes(CHARSET_NAME);
        SecretKeySpec secretKeySpec = new SecretKeySpec(raw, AES);
        Cipher cipher = Cipher.getInstance(AES_PKCS5P);
        cipher.init(cipherMode, secretKeySpec);
        return cipher;
    }

    public static void main(String[] args) throws Exception {
        String pwd = AesUtils.generateSecret(256);
        System.out.println("pwd=" + pwd);
        System.out.println("pwd=" + pwd.length());
        String text = "abcAAA";
        byte[] bytes = "\u6211\u662f\u8c01".getBytes();
        System.out.println(new String(bytes, CHARSET_NAME));
        String encode = AesUtils.encodeBase64(text, pwd);
        System.out.println("encode=" + encode);
        String decrypt2 = AesUtils.decodeBase64(encode, pwd);
        System.out.println("decrypt=" + decrypt2);
    }
}

