/*
 * Decompiled with CFR 0.152.
 */
package top.jaylin.mvparch;

import android.text.TextUtils;
import android.util.Log;

public class MyLog {
    public static String tagPrefix = "MyLog";
    public static boolean debug = false;
    public static int INDEX = 5;

    public static void d(Object o, int index) {
        MyLog.logger("d", o, index);
    }

    public static void e(Object o, int index) {
        MyLog.logger("e", o, index);
    }

    public static void i(Object o, int index) {
        MyLog.logger("i", o, index);
    }

    public static void w(Object o) {
        MyLog.logger("w", o, INDEX);
    }

    public static void d(Object o) {
        MyLog.logger("d", o, INDEX);
    }

    public static void e(Object o) {
        MyLog.logger("e", o, INDEX);
    }

    public static void i(Object o) {
        MyLog.logger("i", o, INDEX);
    }

    public static void w(Object o, int index) {
        MyLog.logger("w", o, index);
    }

    private static void logger(String type, Object o, int index) {
        if (!debug) {
            return;
        }
        String msg = o + "";
        String threadName = Thread.currentThread().getName();
        String tag = MyLog.getTag(MyLog.getCallerStackTraceElement(index)) + ":" + threadName;
        switch (type) {
            case "i": {
                Log.i((String)tag, (String)msg);
                break;
            }
            case "d": {
                Log.d((String)tag, (String)msg);
                break;
            }
            case "e": {
                Log.e((String)tag, (String)msg);
                break;
            }
            case "w": {
                Log.w((String)tag, (String)msg);
            }
        }
    }

    private static String getTag(StackTraceElement element) {
        try {
            String tag = "%s.%s(Line:%d)";
            String callerClazzName = element.getClassName();
            callerClazzName = callerClazzName.substring(callerClazzName.lastIndexOf(".") + 1);
            tag = String.format(tag, callerClazzName, element.getMethodName(), element.getLineNumber());
            tag = TextUtils.isEmpty((CharSequence)tagPrefix) ? tag : tagPrefix + ":" + tag;
            return tag;
        }
        catch (Exception e) {
            return tagPrefix;
        }
    }

    private static StackTraceElement getCallerStackTraceElement(int index) {
        if (index >= Thread.currentThread().getStackTrace().length) {
            index = Thread.currentThread().getStackTrace().length - 1;
        }
        return Thread.currentThread().getStackTrace()[index];
    }
}

