/*
 * Decompiled with CFR 0.152.
 */
package top.jaylin.mvparch;

import android.support.annotation.NonNull;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import top.jaylin.mvparch.BaseMvpView;

public abstract class BasePresenter<DATA, MvpView extends BaseMvpView<DATA>> {
    private ArrayList<Disposable> disposables = new ArrayList();
    private WeakReference<MvpView> mvpViewRef;

    public void addDisposables(Disposable disposable) {
        this.disposables.add(disposable);
    }

    public BasePresenter(@NonNull MvpView mvpView) {
        this.mvpViewRef = new WeakReference<MvpView>(mvpView);
    }

    public MvpView getMvpView() {
        if (this.mvpViewRef != null) {
            return (MvpView)((BaseMvpView)this.mvpViewRef.get());
        }
        return null;
    }

    public void loadData(final boolean isReload, final Object ... param) {
        this.getMvpView().showLoadingView();
        Disposable disposable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<DATA>(){

            public void subscribe(ObservableEmitter<DATA> emitter) throws Exception {
                if (param != null && param.length > 0) {
                    Object data = BasePresenter.this.execution(param);
                    if (!emitter.isDisposed()) {
                        emitter.onNext(data);
                        emitter.onComplete();
                    }
                } else {
                    emitter.onError((Throwable)new NullPointerException("param is NULL"));
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Consumer<DATA>(){

            public void accept(DATA data) throws Exception {
                if (BasePresenter.this.getMvpView() == null) {
                    return;
                }
                BasePresenter.this.getMvpView().hideLoadingView();
                BasePresenter.this.getMvpView().onDataLoadSuccess(data, isReload);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                if (BasePresenter.this.getMvpView() == null) {
                    return;
                }
                BasePresenter.this.getMvpView().hideLoadingView();
                BasePresenter.this.getMvpView().onDataLoadFailed(throwable, isReload);
            }
        });
        this.addDisposables(disposable);
    }

    protected abstract DATA execution(Object ... var1);

    public void dispose() {
        for (int i = 0; i < this.disposables.size(); ++i) {
            Disposable disposable = this.disposables.get(i);
            if (disposable == null) continue;
            disposable.dispose();
        }
        this.disposables.clear();
    }
}

