/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.log.printer.mmap;

import android.util.Log;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import top.heue.utils.log.LogLevel;
import top.heue.utils.log.base.BasePrinter;
import top.heue.utils.log.printer.mmap.FilePrinterLoader;
import top.heue.utils.log.printer.mmap.namer.DateNamer;
import top.heue.utils.log.printer.mmap.namer.IBaseNamer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0004\u00a8\u0006\u0017"}, d2={"Ltop/heue/utils/log/printer/mmap/FilePrinter;", "Ltop/heue/utils/log/base/BasePrinter;", "path", "", "(Ljava/lang/String;)V", "dateFormatter", "Ljava/text/SimpleDateFormat;", "namer", "Ltop/heue/utils/log/printer/mmap/namer/IBaseNamer;", "getNamer", "()Ltop/heue/utils/log/printer/mmap/namer/IBaseNamer;", "setNamer", "(Ltop/heue/utils/log/printer/mmap/namer/IBaseNamer;)V", "value", "getPath", "()Ljava/lang/String;", "setPath", "println", "", "logLevel", "Ltop/heue/utils/log/LogLevel;", "tag", "string", "log_release"})
public final class FilePrinter
extends BasePrinter {
    @NotNull
    private final SimpleDateFormat dateFormatter;
    @NotNull
    private IBaseNamer namer;
    @NotNull
    private String path;

    public FilePrinter(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.CHINA);
        new File(path).mkdirs();
        this.namer = new DateNamer();
        this.path = !StringsKt.endsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) ? path + '/' : path;
    }

    @NotNull
    public final IBaseNamer getNamer() {
        return this.namer;
    }

    public final void setNamer(@NotNull IBaseNamer iBaseNamer) {
        Intrinsics.checkNotNullParameter((Object)iBaseNamer, (String)"<set-?>");
        this.namer = iBaseNamer;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.path = !StringsKt.endsWith$default((CharSequence)value, (char)'/', (boolean)false, (int)2, null) ? value + '/' : value;
    }

    @Override
    public void println(@NotNull LogLevel logLevel, @NotNull String tag, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String fileName = this.namer.get(logLevel, tag, string);
        String str = StringsKt.replace$default((String)string, (String)"\n", (String)"\n        ", (boolean)false, (int)4, null);
        if (StringsKt.endsWith$default((String)str, (String)"\n        ", (boolean)false, (int)2, null)) {
            str = StringsKt.substringBeforeLast$default((String)str, (String)"\n        ", null, (int)2, null);
        }
        Log.e((String)"213", (String)this.path);
        str = this.dateFormatter.format(System.currentTimeMillis()) + " [" + logLevel.name() + "] " + tag + ' ' + str + '\n';
        FilePrinterLoader.write(this.path + fileName, str);
    }
}

