/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.heue.utils.log.L;
import top.heue.utils.log.LogLevel;
import top.heue.utils.log.base.BasePrinter;
import top.heue.utils.log.printer.DefaultPrinter;
import top.heue.utils.log.printer.RecordPrinter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0007J\b\u0010!\u001a\u00020\u001dH\u0003JY\u0010\"\u001a\u00020\u001d*\u00020\u000e2K\u0010#\u001aG\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u001d0$H\u0007J\u0014\u0010\"\u001a\u00020\u001d*\u00020\u000e2\u0006\u0010'\u001a\u00020\bH\u0007J\f\u0010(\u001a\u00020\u001d*\u00020\u000eH\u0007J\u0012\u0010)\u001a\b\u0012\u0004\u0012\u00020+0**\u00020\u000eH\u0007J\f\u0010,\u001a\u00020+*\u00020\u000eH\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\r\u001a\u00020\u0006*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R2\u0010\u0011\u001a\u0016\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\u00050\u0012*\u00020\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\u0018\u001a\u00020\u0005*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Ltop/heue/utils/log/LogUtils;", "", "()V", "apartMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "firstPrinter", "Ltop/heue/utils/log/base/BasePrinter;", "printers", "Ljava/util/LinkedList;", "recordPrinter", "Ltop/heue/utils/log/printer/RecordPrinter;", "apart", "Ltop/heue/utils/log/L;", "getApart", "(Ltop/heue/utils/log/L;)J", "current", "Lkotlin/Pair;", "kotlin.jvm.PlatformType", "getCurrent$annotations", "(Ltop/heue/utils/log/L;)V", "getCurrent", "(Ltop/heue/utils/log/L;)Lkotlin/Pair;", "string", "", "getString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "println", "", "logLevel", "Ltop/heue/utils/log/LogLevel;", "tag", "updatePrinters", "addPrinter", "block", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "printer", "clearAllLog", "getAllLog", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ljava/lang/StringBuffer;", "getAllLogAsStringBuffer", "log_release"})
public final class LogUtils {
    @NotNull
    public static final LogUtils INSTANCE = new LogUtils();
    @NotNull
    private static final LinkedList<BasePrinter> printers = new LinkedList();
    @Nullable
    private static BasePrinter firstPrinter;
    @NotNull
    private static final RecordPrinter recordPrinter;
    @NotNull
    private static ConcurrentHashMap<String, Long> apartMap;

    private LogUtils() {
    }

    @JvmStatic
    public static final void println(@NotNull LogLevel logLevel, @NotNull String tag, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        BasePrinter basePrinter = firstPrinter;
        if (basePrinter != null) {
            basePrinter.printlnAny(logLevel, tag, string);
        }
    }

    @JvmStatic
    public static final void addPrinter(@NotNull L $this$addPrinter, @NotNull Function3<? super LogLevel, ? super String, ? super String, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$addPrinter, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        BasePrinter printer2 = new BasePrinter(block){
            final /* synthetic */ Function3<LogLevel, String, String, Unit> $block;
            {
                this.$block = $block;
            }

            public void println(@NotNull LogLevel logLevel, @NotNull String tag, @NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                this.$block.invoke((Object)((Object)logLevel), (Object)tag, (Object)string);
            }
        };
        LogUtils.addPrinter($this$addPrinter, printer2);
    }

    @JvmStatic
    public static final void addPrinter(@NotNull L $this$addPrinter, @NotNull BasePrinter printer2) {
        Intrinsics.checkNotNullParameter((Object)$this$addPrinter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)printer2, (String)"printer");
        int pos = printers.size() - 1;
        printers.add(pos, printer2);
        INSTANCE.updatePrinters();
    }

    @JvmStatic
    @NotNull
    public static final ConcurrentLinkedDeque<StringBuffer> getAllLog(@NotNull L $this$getAllLog) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllLog, (String)"<this>");
        return recordPrinter.getLog();
    }

    @JvmStatic
    @NotNull
    public static final StringBuffer getAllLogAsStringBuffer(@NotNull L $this$getAllLogAsStringBuffer) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllLogAsStringBuffer, (String)"<this>");
        L l = $this$getAllLogAsStringBuffer;
        boolean bl = false;
        boolean bl2 = false;
        L $this$getAllLogAsStringBuffer_u24lambda_u2d2 = l;
        boolean bl3 = false;
        StringBuffer text = new StringBuffer("");
        Iterable $this$forEach$iv = LogUtils.getAllLog(L.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Appendable appendable;
            StringBuffer it = (StringBuffer)element$iv;
            boolean bl4 = false;
            Appendable appendable2 = text;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)appendable2.append(it), (String)"append(value)");
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
        }
        return text;
    }

    @JvmStatic
    public static final void clearAllLog(@NotNull L $this$clearAllLog) {
        Intrinsics.checkNotNullParameter((Object)$this$clearAllLog, (String)"<this>");
        recordPrinter.getLog().clear();
    }

    @JvmStatic
    private static final void updatePrinters() {
        int n = 0;
        int len = printers.size();
        if (n < len) {
            do {
                int i;
                if ((i = n++) <= 0) continue;
                BasePrinter basePrinter = printers.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)basePrinter, (String)"printers[i]");
                printers.get(i - 1).setNextPrinter(basePrinter);
            } while (n < len);
        }
        firstPrinter = len == 0 ? null : printers.get(0);
    }

    @NotNull
    public final String getString(@NotNull Throwable $this$string) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"<this>");
        Throwable throwable = $this$string;
        boolean bl = false;
        boolean bl2 = false;
        Throwable $this$_get_string__u24lambda_u2d3 = throwable;
        boolean bl3 = false;
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        $this$_get_string__u24lambda_u2d3.printStackTrace(printWriter);
        for (Throwable cause = $this$_get_string__u24lambda_u2d3.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"run {\n            val wr\u2026iter.toString()\n        }");
        return string;
    }

    public final long getApart(@NotNull L $this$apart) {
        Intrinsics.checkNotNullParameter((Object)$this$apart, (String)"<this>");
        L l = $this$apart;
        boolean bl = false;
        boolean bl2 = false;
        L $this$_get_apart__u24lambda_u2d4 = l;
        boolean bl3 = false;
        long result = 0L;
        String tag = (String)LogUtils.getCurrent(L.INSTANCE).getFirst();
        if (apartMap.get(tag) == null) {
            Map map = apartMap;
            Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
            String string = tag;
            Long l2 = System.currentTimeMillis();
            boolean bl4 = false;
            map.put(string, l2);
        } else {
            long l3 = System.currentTimeMillis();
            Long l4 = apartMap.get(tag);
            Intrinsics.checkNotNull((Object)l4);
            Long l5 = l4;
            Intrinsics.checkNotNullExpressionValue((Object)l5, (String)"apartMap[tag]!!");
            result = l3 - ((Number)l5).longValue();
            apartMap.remove(tag);
        }
        return result;
    }

    @NotNull
    public static final Pair<String, String> getCurrent(@NotNull L $this$current) {
        Intrinsics.checkNotNullParameter((Object)$this$current, (String)"<this>");
        L l = $this$current;
        boolean bl = false;
        boolean bl2 = false;
        L $this$_get_current__u24lambda_u2d5 = l;
        boolean bl3 = false;
        StringBuffer forResult = new StringBuffer("");
        Throwable throwable = new Throwable();
        String throwableString = ExceptionsKt.stackTraceToString((Throwable)throwable);
        char[] cArray = new char[]{'\n'};
        List arr = StringsKt.split$default((CharSequence)throwableString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean nearCurrent = false;
        String forMethodName = "";
        int offset = 0;
        int n = 0;
        int n2 = arr.size() + -1;
        if (n <= n2) {
            do {
                String string;
                int pos = n++;
                if (nearCurrent) {
                    CharSequence charSequence = (CharSequence)arr.get(pos + 1);
                    string = $this$_get_current__u24lambda_u2d5.getClass().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.name");
                    if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
                        offset = 2;
                    }
                    CharSequence charSequence2 = (CharSequence)arr.get(pos + offset);
                    string = $this$_get_current__u24lambda_u2d5.getClass().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.name");
                    if (StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)string, (boolean)false, (int)2, null)) {
                        offset = 1;
                    }
                    string = throwable.getStackTrace()[pos - 1 + offset].getMethodName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"throwable.stackTrace[pos - 1 + offset].methodName");
                    forMethodName = string;
                    forResult.append((String)arr.get(pos + offset));
                    break;
                }
                CharSequence charSequence = (CharSequence)arr.get(pos);
                string = $this$_get_current__u24lambda_u2d5.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.name");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) continue;
                nearCurrent = true;
            } while (n <= n2);
        }
        int s = forResult.indexOf("at ") + 3;
        int e = StringsKt.indexOf$default((CharSequence)forResult, (char)'(', (int)0, (boolean)false, (int)6, null);
        String res = forResult.substring(s, e);
        return TuplesKt.to((Object)res, (Object)forMethodName);
    }

    @JvmStatic
    public static /* synthetic */ void getCurrent$annotations(L $this$getCurrent_u24annotations) {
    }

    static {
        recordPrinter = new RecordPrinter();
        LinkedList<BasePrinter> linkedList = printers;
        boolean bl = false;
        boolean bl2 = false;
        LinkedList<BasePrinter> $this$_init__u24lambda_u2d0 = linkedList;
        boolean bl3 = false;
        $this$_init__u24lambda_u2d0.add(new DefaultPrinter());
        $this$_init__u24lambda_u2d0.add(recordPrinter);
        LogUtils.updatePrinters();
        apartMap = new ConcurrentHashMap();
    }
}

