/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.log.printer;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import top.heue.utils.log.LogLevel;
import top.heue.utils.log.base.BasePrinter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltop/heue/utils/log/printer/RecordPrinter;", "Ltop/heue/utils/log/base/BasePrinter;", "()V", "dateFormatter", "Ljava/text/SimpleDateFormat;", "log", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ljava/lang/StringBuffer;", "getLog", "()Ljava/util/concurrent/ConcurrentLinkedDeque;", "logNum", "", "println", "", "logLevel", "Ltop/heue/utils/log/LogLevel;", "tag", "", "string", "log_release"})
public final class RecordPrinter
extends BasePrinter {
    @NotNull
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.CHINA);
    @NotNull
    private final ConcurrentLinkedDeque<StringBuffer> log = new ConcurrentLinkedDeque();
    private int logNum;

    @NotNull
    public final ConcurrentLinkedDeque<StringBuffer> getLog() {
        return this.log;
    }

    @Override
    public void println(@NotNull LogLevel logLevel, @NotNull String tag, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String str = StringsKt.replace$default((String)string, (String)"\n", (String)"\n        ", (boolean)false, (int)4, null);
        if (StringsKt.endsWith$default((String)str, (String)"\n        ", (boolean)false, (int)2, null)) {
            str = StringsKt.substringBeforeLast$default((String)str, (String)"\n        ", null, (int)2, null);
        }
        this.log.add(new StringBuffer(this.dateFormatter.format(System.currentTimeMillis()) + " [" + logLevel.name() + "] " + tag + ' ' + str));
        if (this.logNum > 256) {
            this.log.removeFirst();
        } else {
            RecordPrinter recordPrinter = this;
            int n = recordPrinter.logNum;
            recordPrinter.logNum = n + 1;
        }
    }
}

