/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.util.view;

import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J)\u0010\b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\f\"\u00020\u0001\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltop/heue/utils/base/util/view/TextUtil;", "", "()V", "textView", "Landroid/widget/TextView;", "(Landroid/widget/TextView;)V", "ssb", "Landroid/text/SpannableStringBuilder;", "append", "str", "", "objects", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ltop/heue/utils/base/util/view/TextUtil;", "getSpannableStringBuilder", "inject", "", "Clickable", "ForegroundColor", "base_release"})
public final class TextUtil {
    private TextView textView;
    @NotNull
    private SpannableStringBuilder ssb;

    public TextUtil() {
        this.ssb = new SpannableStringBuilder();
    }

    public TextUtil(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        this();
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        textView.setHighlightColor(0);
        this.textView = textView;
    }

    @NotNull
    public final TextUtil append(@Nullable String str, Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        if (str == null || ((CharSequence)str).length() == 0) {
            return this;
        }
        if (objects.length == 0) {
            this.ssb.append((CharSequence)str);
            return this;
        }
        int begin = this.ssb.length();
        this.ssb.append((CharSequence)str);
        int end = this.ssb.length();
        for (Object element : objects) {
            this.ssb.setSpan(element, begin, end, 33);
        }
        return this;
    }

    public final void inject(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        textView.setHighlightColor(0);
        textView.setText((CharSequence)this.ssb);
    }

    public final void inject() {
        if (this.textView != null) {
            TextView textView = this.textView;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textView");
                textView = null;
            }
            textView.setText((CharSequence)this.ssb);
        }
    }

    @NotNull
    public final SpannableStringBuilder getSpannableStringBuilder() {
        return this.ssb;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0005\"\u0004\b\t\u0010\u0007R\u001e\u0010\n\u001a\u00020\u000b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Ltop/heue/utils/base/util/view/TextUtil$Clickable;", "Landroid/text/style/ClickableSpan;", "()V", "isFakeBoldText", "", "()Z", "setFakeBoldText", "(Z)V", "isUnderlineText", "setUnderlineText", "textColor", "", "getTextColor", "()I", "setTextColor", "(I)V", "updateDrawState", "", "ds", "Landroid/text/TextPaint;", "base_release"})
    public static abstract class Clickable
    extends ClickableSpan {
        private boolean isUnderlineText;
        @ColorInt
        private int textColor = -7829368;
        private boolean isFakeBoldText;

        public boolean isUnderlineText() {
            return this.isUnderlineText;
        }

        public void setUnderlineText(boolean bl) {
            this.isUnderlineText = bl;
        }

        public int getTextColor() {
            return this.textColor;
        }

        public void setTextColor(int n) {
            this.textColor = n;
        }

        public boolean isFakeBoldText() {
            return this.isFakeBoldText;
        }

        public void setFakeBoldText(boolean bl) {
            this.isFakeBoldText = bl;
        }

        public void updateDrawState(@NotNull TextPaint ds) {
            Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
            super.updateDrawState(ds);
            ds.setUnderlineText(this.isUnderlineText());
            ds.setColor(this.getTextColor());
            ds.setFakeBoldText(this.isFakeBoldText());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Ltop/heue/utils/base/util/view/TextUtil$ForegroundColor;", "Landroid/text/style/ForegroundColorSpan;", "color", "", "(I)V", "base_release"})
    public static final class ForegroundColor
    extends ForegroundColorSpan {
        public ForegroundColor(int color) {
            super(color);
        }
    }
}

