/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.helper;

import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\fJ\b\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltop/heue/utils/base/helper/FragmentPagerAdapterHelper;", "Landroidx/viewpager2/adapter/FragmentStateAdapter;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "(Landroidx/appcompat/app/AppCompatActivity;)V", "fragmentClass", "", "Ljava/lang/Class;", "Landroidx/fragment/app/Fragment;", "(Landroidx/appcompat/app/AppCompatActivity;Ljava/util/List;)V", "fragments", "addItem", "", "createFragment", "position", "getItem", "getItemCount", "getItemId", "", "base_release"})
public final class FragmentPagerAdapterHelper
extends FragmentStateAdapter {
    @NotNull
    private AppCompatActivity activity;
    private List<Class<? extends Fragment>> fragments;

    public FragmentPagerAdapterHelper(@NotNull AppCompatActivity activity2) {
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        super((FragmentActivity)activity2);
        this.activity = activity2;
    }

    public FragmentPagerAdapterHelper(@NotNull AppCompatActivity activity2, @NotNull List<Class<? extends Fragment>> fragmentClass) {
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        Intrinsics.checkNotNullParameter(fragmentClass, (String)"fragmentClass");
        this(activity2);
        this.fragments = fragmentClass;
    }

    public int getItemCount() {
        int n;
        if (this.fragments != null) {
            List<Class<? extends Fragment>> list = this.fragments;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fragments");
                list = null;
            }
            n = list.size();
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public Fragment createFragment(int position) {
        List<Class<? extends Fragment>> list = this.fragments;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fragments");
            list = null;
        }
        Fragment fragment = list.get(position).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragments[position].getD\u2026nstructor().newInstance()");
        return fragment;
    }

    public long getItemId(int position) {
        return position;
    }

    @Nullable
    public final Fragment getItem(int position) {
        return this.activity.getSupportFragmentManager().findFragmentById((int)this.getItemId(position));
    }

    public final int addItem(@NotNull Class<? extends Fragment> fragmentClass) {
        Intrinsics.checkNotNullParameter(fragmentClass, (String)"fragmentClass");
        List<Class<? extends Fragment>> list = this.fragments;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fragments");
            list = null;
        }
        list.add(fragmentClass);
        List<Class<? extends Fragment>> list2 = this.fragments;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fragments");
            list2 = null;
        }
        int s = list2.size() - 1;
        this.notifyItemInserted(s);
        return s;
    }
}

