/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.core.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.util.Base64;
import android.util.Log;
import java.security.MessageDigest;

public class VerifyUtil {
    private static final int VALID = 0;
    private static final int INVALID = 1;
    private static final String PLAY_STORE_APP_ID = "com.android.vending";

    public static int checkAppSignature(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            for (Signature signature : packageInfo.signatures) {
                byte[] signatureBytes = signature.toByteArray();
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                String currentSignature = Base64.encodeToString((byte[])md.digest(), (int)0);
                Log.d((String)"REMOVE_ME", (String)("Include this string as a value for SIGNATURE:" + currentSignature));
            }
        }
        catch (Exception e) {
            Log.e((String)"VerifyUtil", (String)e.getMessage());
        }
        return 1;
    }

    public static boolean verifyInstaller(Context context) {
        String installer = context.getPackageManager().getInstallerPackageName(context.getPackageName());
        return installer != null && installer.startsWith(PLAY_STORE_APP_ID);
    }

    private static String getSystemProperty(String name) throws Exception {
        Class<?> systemPropertyClazz = Class.forName("android.os.SystemProperties");
        return (String)systemPropertyClazz.getMethod("get", String.class).invoke(systemPropertyClazz, name);
    }

    public static boolean checkEmulator() {
        try {
            boolean goldfish = VerifyUtil.getSystemProperty("ro.hardware").contains("goldfish");
            boolean emu = VerifyUtil.getSystemProperty("ro.kernel.qemu").length() > 0;
            boolean sdk = VerifyUtil.getSystemProperty("ro.product.model").equals("sdk");
            if (emu || goldfish || sdk) {
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)"VerifyUtil", (String)e.getMessage());
        }
        return false;
    }

    public static boolean checkDebuggable(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }
}

